/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.googlecode.cmakemavenproject.Compiler;
import com.googlecode.cmakemavenproject.Mojos;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public final class VisualStudioCompiler
extends Compiler {
    private static Map<String, Version> compilers = new ImmutableMap.Builder().put((Object)"Visual Studio 6", (Object)Version.V6).put((Object)"Visual Studio 7", (Object)Version.V7_0).put((Object)"Visual Studio 7 .NET 2003", (Object)Version.V7_1).put((Object)"Visual Studio 8", (Object)Version.V8_I386).put((Object)"Visual Studio 8 Win64", (Object)Version.V8_AMD64).put((Object)"Visual Studio 9", (Object)Version.V9_I386).put((Object)"Visual Studio 9 Win64", (Object)Version.V9_AMD64).put((Object)"Visual Studio 10", (Object)Version.V10_I386).put((Object)"Visual Studio 10 Win64", (Object)Version.V10_AMD64).build();
    private final Version version;

    public VisualStudioCompiler(Version version, Log log) {
        super(Compiler.Type.VISUAL_STUDIO, log);
        this.version = version;
    }

    public static VisualStudioCompiler fromGenerator(String name, Log log) {
        Version version = compilers.get(name);
        if (version == null) {
            return null;
        }
        return new VisualStudioCompiler(version, log);
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean compile(File projectPath, String platform, String buildType) throws IOException, InterruptedException {
        String compilerPath;
        ArrayList commandLine = Lists.newArrayList((Object[])new String[]{"cmd.exe", "/c"});
        switch (this.version) {
            case V6: {
                compilerPath = System.getenv("VS60COMNTOOLS");
                break;
            }
            case V7_0: {
                compilerPath = System.getenv("VS70COMNTOOLS");
                break;
            }
            case V7_1: {
                compilerPath = System.getenv("VS71COMNTOOLS");
                break;
            }
            case V8_I386: 
            case V8_AMD64: {
                compilerPath = System.getenv("VS80COMNTOOLS");
                break;
            }
            case V9_I386: 
            case V9_AMD64: {
                compilerPath = System.getenv("VS90COMNTOOLS");
                break;
            }
            case V10_I386: 
            case V10_AMD64: {
                compilerPath = System.getenv("VS100COMNTOOLS");
                break;
            }
            default: {
                throw new AssertionError((Object)this.version);
            }
        }
        switch (this.version) {
            case V6: 
            case V7_0: 
            case V7_1: {
                commandLine.add(new File(compilerPath + "../IDE/devenv.com").getAbsolutePath());
                commandLine.add("/build");
                commandLine.add("\"" + buildType + "|" + platform + "\"");
                commandLine.add(projectPath.toString());
                break;
            }
            case V8_I386: 
            case V8_AMD64: 
            case V9_I386: 
            case V9_AMD64: 
            case V10_I386: 
            case V10_AMD64: {
                commandLine.add(new File(compilerPath + "../../VC/vcvarsall.bat").getAbsolutePath());
                commandLine.add("&&");
                commandLine.add("msbuild");
                commandLine.add("/p:Configuration=" + buildType);
                commandLine.add("/p:Platform=" + platform);
                commandLine.add(projectPath.toString());
                break;
            }
            default: {
                throw new AssertionError((Object)this.version);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).directory(projectPath.getParentFile());
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("buildType: " + buildType));
            log.debug((CharSequence)("platform: " + platform));
            log.debug((CharSequence)("projectPath: " + projectPath));
            log.debug((CharSequence)("command-line: " + processBuilder.command()));
        }
        return Mojos.waitFor(processBuilder) == 0;
    }

    public String toString() {
        return this.getClass().getName() + "[version=" + (Object)((Object)this.version) + "]";
    }

    public static enum Version {
        V6,
        V7_0,
        V7_1,
        V8_I386,
        V8_AMD64,
        V9_I386,
        V9_AMD64,
        V10_I386,
        V10_AMD64;

    }
}

