/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cmakemavenproject;

import com.googlecode.cmakemavenproject.CmakeMojo;
import com.googlecode.cmakemavenproject.Mojos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class TestMojo
extends CmakeMojo {
    @Parameter
    private String config;
    @Parameter(property="ctest.build.dir", required=true)
    private File buildDirectory;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter(property="ctest.skip.tests", defaultValue="false")
    private boolean ctestSkip;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="threadCount", defaultValue="0")
    private int threadCount;
    @Parameter(property="dashboard")
    private String dashboard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skipTests || this.ctestSkip) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)"Tests are skipped.");
            }
            return;
        }
        String buildDir = this.buildDirectory.getAbsolutePath();
        if (!this.buildDirectory.exists()) {
            throw new MojoExecutionException(buildDir + " does not exist");
        }
        if (!this.buildDirectory.isDirectory()) {
            throw new MojoExecutionException(buildDir + " isn't directory");
        }
        if (this.threadCount == 0) {
            this.threadCount = Runtime.getRuntime().availableProcessors();
        }
        try {
            String tag;
            this.downloadBinariesIfNecessary();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.buildDirectory);
            this.overrideEnvironmentVariables(processBuilder);
            String ctestPath = this.getBinaryPath("ctest", processBuilder).toString();
            processBuilder.command().add(ctestPath);
            Collections.addAll(processBuilder.command(), "--test-action", "Test");
            String threadCountString = Integer.toString(this.threadCount);
            Collections.addAll(processBuilder.command(), "--parallel", threadCountString);
            if (this.config != null) {
                Collections.addAll(processBuilder.command(), "--build-config", this.config);
            }
            if (this.dashboard != null) {
                Collections.addAll(processBuilder.command(), "-D", this.dashboard);
            }
            this.addOptions(processBuilder);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("CTest build directory: " + buildDir));
                log.debug((CharSequence)("Number of threads used: " + this.threadCount));
                log.debug((CharSequence)("Environment: " + processBuilder.environment()));
                log.debug((CharSequence)("Command-line: " + processBuilder.command()));
            }
            int returnCode = Mojos.waitFor(processBuilder, this.getLog());
            InputStream stream = TestMojo.class.getResourceAsStream("/ctest2junit.xsl");
            TransformerFactory tf = TransformerFactory.newInstance();
            StreamSource xsltSource = new StreamSource(stream);
            Transformer transformer = tf.newTransformer(xsltSource);
            File tagFile = new File(this.buildDirectory, "/Testing/TAG");
            Charset charset = Charset.defaultCharset();
            FileInputStream fis = new FileInputStream(tagFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
            try (BufferedReader tagReader = new BufferedReader(isr);){
                tag = tagReader.readLine();
            }
            if (tag == null || tag.trim().length() == 0) {
                throw new IOException("Couldn't read ctest TAG file");
            }
            String xmlTestFilePath = "/Testing/" + tag + "/Test.xml";
            File xmlSource = new File(this.buildDirectory, xmlTestFilePath);
            StreamSource source = new StreamSource(xmlSource);
            String projBuildDir = this.project.getBuild().getDirectory();
            File reportsDir = new File(projBuildDir, "surefire-reports");
            File xmlReport = new File(reportsDir, "CTestResults.xml");
            StreamResult result = new StreamResult(xmlReport);
            if (!reportsDir.exists() && !reportsDir.mkdirs()) {
                throw new IOException("Couldn't create " + reportsDir);
            }
            transformer.transform(source, result);
            if (returnCode != 0 && !this.testFailureIgnore) {
                throw new MojoExecutionException("Return code: " + returnCode);
            }
        }
        catch (IOException | InterruptedException | TransformerException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

