/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils;

import com.googlecode.icegem.cacheutils.Executable;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.comparator.CompareTool;
import com.googlecode.icegem.cacheutils.monitor.MonitorTool;
import com.googlecode.icegem.cacheutils.replication.CheckReplicationTool;
import com.googlecode.icegem.cacheutils.signallistener.WaitforTool;
import com.googlecode.icegem.cacheutils.updater.UpdateTool;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class Launcher {
    private static final String DEBUG_OPTION = "debug";
    private static final String QUIET_OPTION = "quiet";
    private static final String HELP_OPTION = "help";
    private static final boolean DEFAULT_DEBUG_ENABLED = false;
    private static final boolean DEFAULT_QUIET = false;
    private static boolean debugEnabled = false;
    private static boolean quiet = false;

    private static void printHelp() {
        Options options = Launcher.constructGnuOptions();
        Launcher.printHelp(options);
    }

    private static void parseCommandLineArguments(String[] commandLineArguments) {
        Options options = Launcher.constructGnuOptions();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, commandLineArguments);
            if (line.hasOption(HELP_OPTION)) {
                Launcher.printHelp(options);
            }
            if (line.hasOption(DEBUG_OPTION)) {
                debugEnabled = true;
            }
            if (!debugEnabled && line.hasOption(QUIET_OPTION)) {
                quiet = true;
            }
        }
        catch (Throwable t) {
            Launcher.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        StringBuilder sb = new StringBuilder();
        sb.append("java -jar icegem-cache-utils-<version>.jar [options] <");
        Command[] commands = Command.values();
        for (int i = 0; i < commands.length; ++i) {
            sb.append(commands[i].getName());
            if (i >= commands.length - 1) continue;
            sb.append(" | ");
        }
        sb.append("> [command_specific_options]");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(sb.toString(), options);
        Utils.exitWithFailure();
    }

    private static Options constructGnuOptions() {
        Options gnuOptions = new Options();
        gnuOptions.addOption("d", DEBUG_OPTION, false, "Print debug information").addOption("q", QUIET_OPTION, false, "Quiet output. Doesn't work if --debug specified.").addOption("h", HELP_OPTION, false, "Print usage information");
        return gnuOptions;
    }

    private static int findCommandIndex(String[] args) {
        int commandIndex = -1;
        block0: for (int i = 0; i < args.length; ++i) {
            for (Command command : Command.values()) {
                if (!command.getName().equals(args[i].trim())) continue;
                commandIndex = i;
                continue block0;
            }
        }
        return commandIndex;
    }

    private static String[] extractLauncherArgs(String[] args, int commandIndex) {
        String[] launcherArgs = new String[commandIndex];
        System.arraycopy(args, 0, launcherArgs, 0, commandIndex);
        return launcherArgs;
    }

    private static String[] extractCommandArgs(String[] args, int commandIndex) {
        String[] commandArgs = new String[args.length - commandIndex - 1];
        System.arraycopy(args, commandIndex + 1, commandArgs, 0, args.length - commandIndex - 1);
        return commandArgs;
    }

    public static void main(String[] args) {
        try {
            int commandIndex = Launcher.findCommandIndex(args);
            if (commandIndex < 0) {
                Launcher.printHelp();
            }
            String[] launcherArgs = Launcher.extractLauncherArgs(args, commandIndex);
            String[] commandArgs = Launcher.extractCommandArgs(args, commandIndex);
            Launcher.parseCommandLineArguments(launcherArgs);
            Launcher.debug("Launcher#main(): args = " + Arrays.asList(args));
            Launcher.debug("Launcher#main(): launcherArgs = " + Arrays.asList(launcherArgs));
            Launcher.debug("Launcher#main(): commandArgs = " + Arrays.asList(commandArgs));
            String commandName = args[commandIndex];
            Executable tool = Command.getUtil(commandName);
            if (tool != null) {
                tool.execute(commandArgs, debugEnabled, quiet);
            } else {
                Launcher.debug("Launcher#main(): Command \"" + commandName + "\" not found");
                Launcher.printHelp();
            }
        }
        catch (Throwable t) {
            Launcher.debug("Launcher#main(): Throwable caught with message = " + t.getMessage(), t);
            Utils.exitWithFailure("Unexpected throwable", t);
        }
    }

    private static void debug(String message) {
        Launcher.debug(message, null);
    }

    private static void debug(String message, Throwable t) {
        if (debugEnabled) {
            System.err.println("0 [Launcher] " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        COMPARE("compare", new CompareTool()),
        MONITOR("monitor", new MonitorTool()),
        CHECK_REPLICATION("check-replication", new CheckReplicationTool()),
        UPDATE("update", new UpdateTool()),
        WAITFOR("waitfor", new WaitforTool());

        private String name;
        private Executable exec;

        private Command(String name, Executable exec) {
            this.name = name;
            this.exec = exec;
        }

        public String getName() {
            return this.name;
        }

        public Executable getExec() {
            return this.exec;
        }

        public static Executable getUtil(String commandName) {
            Executable result = null;
            for (Command command : Command.values()) {
                if (!command.getName().equals(commandName.trim())) continue;
                result = command.getExec();
                break;
            }
            return result;
        }
    }
}

