/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.common;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.googlecode.icegem.utils.PropertiesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminService {
    private AdminDistributedSystem admin;
    private Map<String, String> regionNames;
    private Set<SystemMember> systemMembers = new HashSet<SystemMember>();
    private DistributedSystem connection;

    public AdminService(String locator) throws Exception {
        this(locator, true);
    }

    public AdminService(String locator, boolean logToFile) throws Exception {
        this.admin = this.adminCreateAndConnect(locator, logToFile);
        this.systemMembers.addAll(new HashSet<CacheVm>(Arrays.asList(this.admin.getCacheVms())));
        this.systemMembers.addAll(new HashSet<SystemMember>(Arrays.asList(this.admin.getSystemMemberApplications())));
    }

    public Map<String, String> getRegionNames(String regionNamesOption, boolean withSubRegionsOption) throws AdminException {
        this.regionNames = new TreeMap<String, String>();
        if (regionNamesOption.equals("all")) {
            return this.getSystemRegionNames(null, true);
        }
        String[] regionNamesArray = regionNamesOption.split(",");
        return this.getSystemRegionNames(Arrays.asList(regionNamesArray), withSubRegionsOption);
    }

    public Map<String, SystemMemberRegion> getMemberRegionMap(String name) throws AdminException {
        HashMap<String, SystemMemberRegion> result = new HashMap<String, SystemMemberRegion>();
        for (SystemMember member : this.systemMembers) {
            SystemMemberCache cache;
            SystemMemberRegion region;
            if (!member.hasCache() || (region = (cache = member.getCache()).getRegion(name)) == null) continue;
            result.put(member.getId(), region);
        }
        return result;
    }

    public void close() {
        this.admin.disconnect();
        this.connection.disconnect();
    }

    private Map<String, String> getSystemRegionNames(List<String> regionNamesToFind, boolean withSubRegionsOption) throws AdminException {
        for (SystemMember member : this.systemMembers) {
            if (!member.hasCache()) continue;
            SystemMemberCache cache = member.getCache();
            for (Object name : cache.getRootRegionNames()) {
                this.getSubregionsNameRequrcively(cache, "/" + name, regionNamesToFind, withSubRegionsOption);
            }
        }
        return this.regionNames;
    }

    private void getSubregionsNameRequrcively(SystemMemberCache cache, String path, List<String> regionNamesToFind, boolean withSubRegionsOption) throws AdminException {
        SystemMemberRegion region = cache.getRegion(path);
        if (region != null) {
            if (regionNamesToFind == null || regionNamesToFind.contains(region.getName()) || withSubRegionsOption && new ArrayList<String>(Arrays.asList(path.split("/"))).removeAll(regionNamesToFind)) {
                this.regionNames.put(path, region.getName());
            }
            Set subregionsPaths = region.getSubregionFullPaths();
            for (String subregionsPath : subregionsPaths) {
                this.getSubregionsNameRequrcively(cache, subregionsPath, regionNamesToFind, withSubRegionsOption);
            }
        }
    }

    private AdminDistributedSystem adminCreateAndConnect(String locator, boolean logToFile) throws Exception {
        PropertiesHelper propertiesHelper = new PropertiesHelper("/adminservice.properties");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("license-type", propertiesHelper.getStringProperty("icegem.cacheutils.adminservice.gemfire.license.type"));
        props.setProperty("license-file", propertiesHelper.getStringProperty("icegem.cacheutils.adminservice.gemfire.license.file"));
        if (locator != null) {
            props.setProperty("locators", locator);
        }
        if (logToFile) {
            props.setProperty("log-file", "admin.log");
        } else {
            props.setProperty("log-level", "none");
        }
        AdminDistributedSystemFactory.setEnableAdministrationOnly((boolean)false);
        this.connection = DistributedSystem.connect((Properties)props);
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)this.connection, null);
        AdminDistributedSystem admin = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        admin.connect();
        long timeout = 30000L;
        try {
            if (!admin.waitToBeConnected(timeout)) {
                String s = "Could not connect after " + timeout + "ms";
                throw new Exception(s);
            }
        }
        catch (InterruptedException ex) {
            String s = "Interrupted while waiting to be connected";
            throw new Exception(s, ex);
        }
        return admin;
    }

    public AdminDistributedSystem getAdmin() {
        return this.admin;
    }

    public void setAdmin(AdminDistributedSystem admin) {
        this.admin = admin;
    }
}

