/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.common;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.HierarchyRegistry;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerCacheService {
    private static final Logger log = LoggerFactory.getLogger(PeerCacheService.class);
    private ClientCache cache;
    private List<String> scanPackages = new ArrayList<String>();
    private ClientRegionFactory proxyRegionFactory;

    public PeerCacheService(String serverOptionsString, List<String> scanPackages) throws Exception {
        String[] serverOptions;
        if (scanPackages != null) {
            this.scanPackages = scanPackages;
            this.registerSerializers();
        }
        ClientCacheFactory clientCacheFactory = new ClientCacheFactory();
        for (String serverOption : serverOptions = serverOptionsString.split(",")) {
            if (serverOption == null) continue;
            String serverHost = serverOption.substring(0, serverOption.indexOf("["));
            String serverPort = serverOption.substring(serverOption.indexOf("[") + 1, serverOption.indexOf("]"));
            clientCacheFactory.addPoolServer(serverHost, Integer.parseInt(serverPort));
        }
        clientCacheFactory.set("log-level", "none");
        this.cache = clientCacheFactory.create();
    }

    public Set<Region<?, ?>> createRegions(Map<String, String> regionNames) {
        HashSet regions = new HashSet();
        this.proxyRegionFactory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        for (String regionPath : regionNames.keySet()) {
            Region<?, ?> region = this.createRegion(regionPath, regionNames.get(regionPath));
            regions.add(region);
        }
        return regions;
    }

    public Region<?, ?> createRegion(Map<String, String> regionNames) {
        this.proxyRegionFactory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        Region<?, ?> region = null;
        for (Map.Entry<String, String> e : regionNames.entrySet()) {
            region = this.createRegion(e.getKey(), e.getValue());
        }
        return region;
    }

    private Region<?, ?> createRegion(String regionPath, String regionName) {
        Region region = null;
        if (regionPath.equals("/" + regionName)) {
            region = this.proxyRegionFactory.create(regionName);
        } else {
            Region parentRegion = this.cache.getRegion(regionPath.substring(0, regionPath.lastIndexOf("/" + regionName)));
            if (parentRegion != null) {
                region = parentRegion.createSubregion(regionName, parentRegion.getAttributes());
            }
        }
        return region;
    }

    public void close() {
        this.cache.close();
    }

    private void registerSerializers() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.registerClasses(classLoader);
    }

    private void registerClasses(ClassLoader classLoader) throws Exception {
        String msg;
        ArrayList classesFromPackages = new ArrayList();
        for (String pack : this.scanPackages) {
            log.info("Scan package " + pack + " for classes marked by @AutoSerializable");
            ClassPathScanningCandidateComponentProvider ppp = new ClassPathScanningCandidateComponentProvider(false);
            ppp.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AutoSerializable.class));
            Set candidateComponents = ppp.findCandidateComponents(pack);
            for (BeanDefinition beanDefinition : candidateComponents) {
                String className = beanDefinition.getBeanClassName();
                Class<?> clazz = Class.forName(className);
                classesFromPackages.add(clazz);
            }
        }
        try {
            HierarchyRegistry.registerAll((ClassLoader)classLoader, classesFromPackages);
        }
        catch (InvalidClassException e) {
            msg = "Some class from list " + classesFromPackages + " is nor serializable. Cause: " + e.getMessage();
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
        catch (CannotCompileException e) {
            msg = "Can't compile DataSerializer classes for some classes from list " + classesFromPackages + ". Cause: " + e.getMessage();
            log.error(msg);
            throw new RuntimeException(msg, e);
        }
    }
}

