/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.common;

import com.googlecode.icegem.cacheutils.monitor.controller.model.Node;
import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.HierarchyRegistry;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public static String toKey(Node node) {
        return Utils.toKey(node.getHost(), node.getPort());
    }

    public static String toKey(String host, int port) {
        return host + ":" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSocketAlive(String host, int port) {
        boolean socketAlive = false;
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            socketAlive = socket.isConnected();
        }
        catch (Throwable t) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return socketAlive;
    }

    public static void execute(Thread thread, long timeout) {
        thread.start();
        try {
            thread.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            thread.interrupt();
        }
    }

    public static void execute(Runnable runnable, long timeout) {
        Utils.execute(new Thread(runnable), timeout);
    }

    public static String dateToString(Date date) {
        return formatter.format(date);
    }

    public static String dateToString(long date) {
        return Utils.dateToString(new Date(date));
    }

    public static String currentDate() {
        return Utils.dateToString(System.currentTimeMillis());
    }

    public static void exitWithSuccess() {
        System.exit(0);
    }

    public static void exitWithFailure(String message, Throwable t) {
        if (message != null) {
            System.err.println(message);
        }
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.exit(1);
    }

    public static void exitWithFailure(String message) {
        Utils.exitWithFailure(message, null);
    }

    public static void exitWithFailure() {
        Utils.exitWithFailure(null);
    }

    public static void registerClasses(List<String> packages) throws Exception {
        if (packages != null && packages.size() > 0) {
            ArrayList classesFromPackages = new ArrayList();
            for (String pack : packages) {
                ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
                provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AutoSerializable.class));
                Set candidateComponents = provider.findCandidateComponents(pack);
                for (BeanDefinition beanDefinition : candidateComponents) {
                    String className = beanDefinition.getBeanClassName();
                    Class<?> clazz = Class.forName(className);
                    classesFromPackages.add(clazz);
                }
            }
            HierarchyRegistry.registerAll((ClassLoader)Thread.currentThread().getContextClassLoader(), classesFromPackages);
        }
    }
}

