/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.comparator;

import com.googlecode.icegem.cacheutils.Tool;
import com.googlecode.icegem.cacheutils.common.FileService;
import com.googlecode.icegem.cacheutils.common.Stopwatch;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.comparator.model.ComparisonResult;
import com.googlecode.icegem.cacheutils.comparator.model.Node;
import com.googlecode.icegem.cacheutils.comparator.task.GetNodesTask;
import com.googlecode.icegem.cacheutils.comparator.task.GetNodesTaskArguments;
import com.googlecode.icegem.utils.JavaProcessLauncher;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class CompareTool
extends Tool {
    public static final String PARTITION = "partition";
    public static final String REPLICATE = "replicate";
    private static final String PACKAGES_OPTION = "packages";
    private static final String TARGET_SERVER_OPTION = "target-server";
    private static final String TARGET_REGION_OPTION = "target-region";
    private static final String TARGET_LOCATORS_OPTION = "target-locators";
    private static final String SOURCE_SERVER_OPTION = "source-server";
    private static final String SOURCE_REGION_OPTION = "source-region";
    private static final String SOURCE_LOCATORS_OPTION = "source-locators";
    private static final String LOAD_FACTOR_OPTION = "load-factor";
    private static final String HELP_OPTION = "help";
    private static final String SOURCE_INPUT_FILENAME = "source-input-object";
    private static final String TARGET_INPUT_FILENAME = "target-input-object";
    private static final String SOURCE_OUTPUT_FILENAME = "source-output-object";
    private static final String TARGET_OUTPUT_FILENAME = "target-output-object";
    private static final int DEFAULT_LOAD_FACTOR = 50;
    private String sourceRegionName;
    private String sourceServer = null;
    private String sourceLocators = null;
    private String targetRegionName;
    private String targetServer = null;
    private String targetLocators = null;
    private List<String> packages;
    private int loadFactor = 50;
    private Stopwatch stopwatch = new Stopwatch();
    private JavaProcessLauncher javaProcessLauncher = new JavaProcessLauncher(false, false, false);

    public void execute(String[] args, boolean debugEnabled, boolean quiet) {
        try {
            this.parseCommandLineArguments(args);
            this.compare(new long[]{0L}, 64);
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Unexpected throwable", t);
        }
    }

    private void compare(long[] ids, int shift) throws IOException, InterruptedException, ClassNotFoundException {
        this.stopwatch.start();
        long[] childIds = this.getDifferentChildrenIds(ids, shift);
        this.stopwatch.stop();
        System.out.println("level #" + (80 - shift) / 16 + ", number of different entries detected: " + childIds.length + " in " + this.stopwatch.getDuration() + "ms");
        if (childIds.length > 0) {
            if (shift > 32) {
                this.compare(childIds, shift - 16);
            } else {
                this.stopwatch.start();
                ComparisonResult result = this.calculateResult(childIds);
                this.stopwatch.stop();
                System.out.println("level #4, number of different entries detected: [extra: " + result.getExtra().size() + ", missed: " + result.getMissed().size() + ", different: " + result.getDifferent().size() + "] in " + this.stopwatch.getDuration() + "ms");
                System.out.println(result);
                Utils.exitWithFailure();
            }
        } else {
            System.out.println("equal");
            Utils.exitWithSuccess();
        }
    }

    private Process runProcess(String mode, String address, String regionName, String inputFilename, String outputFilename, long[] ids, int shift) throws IOException, InterruptedException {
        GetNodesTaskArguments arguments = new GetNodesTaskArguments();
        arguments.setAddress(address);
        arguments.setRegionName(regionName);
        arguments.setFilename(outputFilename);
        arguments.setLoadFactor(this.loadFactor);
        arguments.setPackages(this.packages);
        arguments.setIds(ids);
        arguments.setShift(shift);
        arguments.setMode(mode);
        FileService.writeObject(inputFilename, arguments);
        Process process = this.javaProcessLauncher.runWithoutConfirmation(GetNodesTask.class, null, new String[]{inputFilename});
        return process;
    }

    private ComparisonResult calculateResult(long[] ids) throws IOException, InterruptedException, ClassNotFoundException {
        Process targetProcess;
        Process sourceProcess;
        ComparisonResult result = new ComparisonResult();
        if (this.isPartitioned()) {
            sourceProcess = this.runProcess(PARTITION, this.sourceLocators, this.sourceRegionName, SOURCE_INPUT_FILENAME, SOURCE_OUTPUT_FILENAME, ids, 16);
            targetProcess = this.runProcess(PARTITION, this.targetLocators, this.targetRegionName, TARGET_INPUT_FILENAME, TARGET_OUTPUT_FILENAME, ids, 16);
        } else {
            sourceProcess = this.runProcess(REPLICATE, this.sourceServer, this.sourceRegionName, SOURCE_INPUT_FILENAME, SOURCE_OUTPUT_FILENAME, ids, 16);
            targetProcess = this.runProcess(REPLICATE, this.targetServer, this.targetRegionName, TARGET_INPUT_FILENAME, TARGET_OUTPUT_FILENAME, ids, 16);
        }
        sourceProcess.waitFor();
        targetProcess.waitFor();
        Set sourceNodesSet = (Set)FileService.readObject(SOURCE_OUTPUT_FILENAME);
        Set targetNodesSet = (Set)FileService.readObject(TARGET_OUTPUT_FILENAME);
        HashMap<Object, Long> sourceDataToHashcodeMap = new HashMap<Object, Long>();
        HashMap<Object, Long> targetDataToHashcodeMap = new HashMap<Object, Long>();
        for (Node node : sourceNodesSet) {
            for (Node child : node.getChildren()) {
                sourceDataToHashcodeMap.put(child.getData(), child.getHashcode());
            }
        }
        for (Node node : targetNodesSet) {
            for (Node child : node.getChildren()) {
                targetDataToHashcodeMap.put(child.getData(), child.getHashcode());
            }
        }
        HashSet dataSet = new HashSet();
        dataSet.addAll(sourceDataToHashcodeMap.keySet());
        dataSet.addAll(targetDataToHashcodeMap.keySet());
        for (Object data : dataSet) {
            Long sourceHashcode = (Long)sourceDataToHashcodeMap.get(data);
            Long targetHashcode = (Long)targetDataToHashcodeMap.get(data);
            if (sourceHashcode == null) {
                result.addMissed(data);
                continue;
            }
            if (targetHashcode == null) {
                result.addExtra(data);
                continue;
            }
            if (sourceHashcode.longValue() != targetHashcode.longValue()) {
                result.addDifferent(data);
                continue;
            }
            throw new IllegalStateException("The entry with key = " + data + " neither extra, missed nor different");
        }
        return result;
    }

    private long[] getDifferentChildrenIds(long[] ids, int shift) throws IOException, InterruptedException, ClassNotFoundException {
        Process targetProcess;
        Process sourceProcess;
        if (this.isPartitioned()) {
            sourceProcess = this.runProcess(PARTITION, this.sourceLocators, this.sourceRegionName, SOURCE_INPUT_FILENAME, SOURCE_OUTPUT_FILENAME, ids, shift);
            targetProcess = this.runProcess(PARTITION, this.targetLocators, this.targetRegionName, TARGET_INPUT_FILENAME, TARGET_OUTPUT_FILENAME, ids, shift);
        } else {
            sourceProcess = this.runProcess(REPLICATE, this.sourceServer, this.sourceRegionName, SOURCE_INPUT_FILENAME, SOURCE_OUTPUT_FILENAME, ids, shift);
            targetProcess = this.runProcess(REPLICATE, this.targetServer, this.targetRegionName, TARGET_INPUT_FILENAME, TARGET_OUTPUT_FILENAME, ids, shift);
        }
        sourceProcess.waitFor();
        targetProcess.waitFor();
        Set sourceNodesSet = (Set)FileService.readObject(SOURCE_OUTPUT_FILENAME);
        Set targetNodesSet = (Set)FileService.readObject(TARGET_OUTPUT_FILENAME);
        HashMap<Long, Node> sourceIdToNodeMap = new HashMap<Long, Node>();
        HashMap<Long, Node> targetIdToNodeMap = new HashMap<Long, Node>();
        for (Node node : sourceNodesSet) {
            sourceIdToNodeMap.put(node.getId(), node);
        }
        for (Node node : targetNodesSet) {
            targetIdToNodeMap.put(node.getId(), node);
        }
        HashSet idsSet = new HashSet();
        idsSet.addAll(sourceIdToNodeMap.keySet());
        idsSet.addAll(targetIdToNodeMap.keySet());
        HashSet<Long> differentIdsSet = new HashSet<Long>();
        for (Long id : idsSet) {
            long targetHashcode;
            Node sourceNode = (Node)sourceIdToNodeMap.get(id);
            Node targetNode = (Node)targetIdToNodeMap.get(id);
            if (sourceNode == null) {
                differentIdsSet.addAll(targetNode.getChildrenIdsSet());
                continue;
            }
            if (targetNode == null) {
                differentIdsSet.addAll(sourceNode.getChildrenIdsSet());
                continue;
            }
            long sourceHashcode = sourceNode.getHashcode();
            if (sourceHashcode == (targetHashcode = targetNode.getHashcode())) continue;
            Node[] sourceChildren = sourceNode.getChildren();
            Node[] targetChildren = targetNode.getChildren();
            HashMap<Long, Node> childrenSourceIdToNodeMap = new HashMap<Long, Node>();
            HashMap<Long, Node> childrenTargetIdToNodeMap = new HashMap<Long, Node>();
            for (Node node : sourceChildren) {
                childrenSourceIdToNodeMap.put(node.getId(), node);
            }
            for (Node node : targetChildren) {
                childrenTargetIdToNodeMap.put(node.getId(), node);
            }
            HashSet childrenIdsSet = new HashSet();
            childrenIdsSet.addAll(childrenSourceIdToNodeMap.keySet());
            childrenIdsSet.addAll(childrenTargetIdToNodeMap.keySet());
            for (Long childId : childrenIdsSet) {
                Node childSourceNode = (Node)childrenSourceIdToNodeMap.get(childId);
                Node childTargetNode = (Node)childrenTargetIdToNodeMap.get(childId);
                if (childSourceNode == null) {
                    differentIdsSet.add(childTargetNode.getId());
                    continue;
                }
                if (childTargetNode == null) {
                    differentIdsSet.add(childSourceNode.getId());
                    continue;
                }
                if (childSourceNode.getHashcode() == childTargetNode.getHashcode()) continue;
                differentIdsSet.add(childSourceNode.getId());
            }
        }
        long[] childIds = new long[differentIdsSet.size()];
        int i = 0;
        for (Long id : differentIdsSet) {
            childIds[i++] = id;
        }
        return childIds;
    }

    private boolean isPartitioned() {
        return this.sourceLocators != null && this.targetLocators != null;
    }

    protected void parseCommandLineArguments(String[] commandLineArguments) {
        block16: {
            Options options = this.constructGnuOptions();
            if (commandLineArguments.length < 1) {
                this.printHelp(options);
            }
            GnuParser parser = new GnuParser();
            try {
                CommandLine line = parser.parse(options, commandLineArguments);
                if (line.hasOption(HELP_OPTION)) {
                    this.printHelp(options);
                }
                if (line.hasOption(SOURCE_REGION_OPTION)) {
                    this.sourceRegionName = line.getOptionValue(SOURCE_REGION_OPTION);
                } else {
                    this.printHelp(options);
                }
                if (line.hasOption(TARGET_REGION_OPTION)) {
                    this.targetRegionName = line.getOptionValue(TARGET_REGION_OPTION);
                } else {
                    this.printHelp(options);
                }
                if (line.hasOption(SOURCE_SERVER_OPTION) && line.hasOption(TARGET_SERVER_OPTION)) {
                    this.sourceServer = line.getOptionValue(SOURCE_SERVER_OPTION);
                    this.targetServer = line.getOptionValue(TARGET_SERVER_OPTION);
                } else if (line.hasOption(SOURCE_LOCATORS_OPTION) && line.hasOption(TARGET_LOCATORS_OPTION)) {
                    this.sourceLocators = line.getOptionValue(SOURCE_LOCATORS_OPTION);
                    this.targetLocators = line.getOptionValue(TARGET_LOCATORS_OPTION);
                } else {
                    this.printHelp(options);
                }
                if (line.hasOption(PACKAGES_OPTION)) {
                    this.packages = Arrays.asList(line.getOptionValue(PACKAGES_OPTION).split(","));
                }
                if (!line.hasOption(LOAD_FACTOR_OPTION)) break block16;
                String loadFactorString = line.getOptionValue(LOAD_FACTOR_OPTION);
                try {
                    this.loadFactor = Integer.parseInt(loadFactorString);
                }
                catch (Throwable t) {
                    Utils.exitWithFailure("Cannot parse the load-factor option, value = " + loadFactorString);
                }
                if (this.loadFactor < 1 || this.loadFactor > 100) {
                    Utils.exitWithFailure("The load-factor option, value = " + loadFactorString + " is out of range [1, 100]");
                }
            }
            catch (Throwable t) {
                Utils.exitWithFailure("Throwable caught during the command-line arguments parsing", t);
            }
        }
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("compare <--source-region> <--target-region> < --source-server --target-server | --source-locators --target-locators > [--packages] [--load-factor]", options);
        Utils.exitWithFailure();
    }

    protected Options constructGnuOptions() {
        Options gnuOptions = new Options();
        gnuOptions.addOption("sr", SOURCE_REGION_OPTION, true, "The name of source region").addOption("ss", SOURCE_SERVER_OPTION, true, "Source server in format host[port]").addOption("sl", SOURCE_LOCATORS_OPTION, true, "Source cluster locators in format host1[port1],host2[port2]").addOption("tr", TARGET_REGION_OPTION, true, "The name of target region").addOption("ts", TARGET_SERVER_OPTION, true, "Target server in format host[port]").addOption("tl", TARGET_LOCATORS_OPTION, true, "Target cluster locators in format host1[port1],host2[port2]").addOption("lf", LOAD_FACTOR_OPTION, true, "The percent of time the comparator tries to use on each server. The possible values range [1, 100]. Default value is 50.").addOption("c", PACKAGES_OPTION, true, "Enumerate packages to scan for @AutoSerializable model classes. Delimiter is a comma sign.").addOption("h", HELP_OPTION, false, "Print usage information");
        return gnuOptions;
    }
}

