/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.comparator.function;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.comparator.function.GetNodesFunctionArguments;
import com.googlecode.icegem.cacheutils.comparator.model.Node;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNodesFunction
extends FunctionAdapter
implements Declarable {
    private static final long serialVersionUID = -6448375948152121283L;
    private static final int BASE_MULTIPLIER = 1;

    public void init(Properties arg0) {
    }

    public void execute(FunctionContext functionContext) {
        ResultSender resultSender = functionContext.getResultSender();
        try {
            RegionFunctionContext context = (RegionFunctionContext)functionContext;
            GetNodesFunctionArguments arguments = (GetNodesFunctionArguments)context.getArguments();
            Utils.registerClasses(arguments.getPackages());
            Region region = context.getDataSet();
            if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
                region = PartitionRegionHelper.getLocalData((Region)region);
            }
            Node[] nodes = this.getNodes(region, arguments.getLoadFactor(), arguments.getIds(), arguments.getShift());
            resultSender.lastResult((Serializable)nodes);
        }
        catch (Throwable t) {
            resultSender.sendException(t);
        }
    }

    public Node[] getNodes(Region<?, ?> region, Integer loadFactor, long[] ids, int shift) {
        Map<Long, Node> idToNodeMap = this.createIdToNodeMap(ids);
        long baseMask = shift > 63 ? 0L : -1L << shift;
        long childrenBaseMask = -1L << shift - 16;
        long lastWakeUpTime = System.currentTimeMillis();
        for (Object key : region.keySet()) {
            Object value = region.get(key);
            long entryHashcode = this.calculateEntryHashcode(key, value);
            long id = entryHashcode & baseMask;
            long childId = entryHashcode & childrenBaseMask;
            Node node = idToNodeMap.get(id);
            if (node != null) {
                Node newNode = new Node(id);
                Node child = new Node(childId);
                child.addHashcode(entryHashcode);
                if (childrenBaseMask == -1L) {
                    child.setData(key);
                }
                newNode.addChild(child);
                newNode.addHashcode(entryHashcode);
                node.merge(newNode);
                idToNodeMap.put(id, node);
            }
            lastWakeUpTime = this.sleep(lastWakeUpTime, loadFactor);
        }
        return this.mapToNodeArray(idToNodeMap);
    }

    private Map<Long, Node> createIdToNodeMap(long[] ids) {
        HashMap<Long, Node> result = new HashMap<Long, Node>();
        for (long id : ids) {
            result.put(id, new Node(id));
        }
        return result;
    }

    private Node[] mapToNodeArray(Map<Long, Node> map) {
        Collection<Node> values = map.values();
        return values.toArray(new Node[values.size()]);
    }

    private long calculateEntryHashcode(Object key, Object value) {
        int keyHashcode = key.hashCode();
        int valueHashcode = value.hashCode();
        return ((long)valueHashcode << 32) + (long)keyHashcode;
    }

    private long sleep(long lastWakeUpTime, Integer loadFactor) {
        long nextSleepTime = lastWakeUpTime + (long)(1 * loadFactor);
        long currentTime = System.currentTimeMillis();
        boolean hasSleep = false;
        if (currentTime > nextSleepTime) {
            try {
                Thread.sleep(1 * (100 - loadFactor));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            hasSleep = true;
        }
        long newLastWakeUpTime = hasSleep ? System.currentTimeMillis() : lastWakeUpTime;
        return newLastWakeUpTime;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isHA() {
        return false;
    }
}

