/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.comparator.function;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.googlecode.icegem.cacheutils.comparator.model.Node;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNodesResultCollector
implements ResultCollector<Serializable, Serializable> {
    private Semaphore lock = new Semaphore(1);
    private Map<Long, Node> idToNodeMap = new HashMap<Long, Node>();

    public void addResult(DistributedMember member, Serializable value) {
        try {
            this.lock.acquire();
            if (value instanceof Node[]) {
                Node[] nodes;
                for (Node node : nodes = (Node[])value) {
                    Node registeredNode = this.idToNodeMap.get(node.getId());
                    if (registeredNode == null) {
                        registeredNode = node;
                    } else {
                        registeredNode.merge(node);
                    }
                    this.idToNodeMap.put(registeredNode.getId(), registeredNode);
                }
            }
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public void clearResults() {
        try {
            this.lock.acquire();
            this.idToNodeMap = new HashMap<Long, Node>();
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public void endResults() {
    }

    public Serializable getResult() throws FunctionException {
        try {
            this.lock.acquire();
            HashSet<Node> hashSet = this.prepareResult();
            return hashSet;
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public Serializable getResult(long timeout, TimeUnit timeUnit) throws FunctionException, InterruptedException {
        try {
            if (!this.lock.tryAcquire(timeout, timeUnit)) {
                throw new FunctionException("Timeout during the lock acquiring");
            }
            HashSet<Node> hashSet = this.prepareResult();
            return hashSet;
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    private HashSet<Node> prepareResult() {
        return new HashSet<Node>(this.idToNodeMap.values());
    }
}

