/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.comparator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Serializable {
    private static final long serialVersionUID = 6882283061702312942L;
    private long id;
    private long hashcode = 0L;
    private Object data;
    private Node[] children;

    public Node(long id) {
        this.id = id;
        this.children = new Node[0];
    }

    public void merge(Node other) {
        Node[] otherChildren;
        if (other.getId() != this.id) {
            throw new IllegalArgumentException("Id of merged node must be the same as id of this node");
        }
        this.addHashcode(other.getHashcode());
        for (Node otherChild : otherChildren = other.getChildren()) {
            Node child = this.getChild(otherChild.getId());
            if (child == null) {
                this.addChild(otherChild);
                continue;
            }
            child.merge(otherChild);
        }
    }

    public long getId() {
        return this.id;
    }

    public long getHashcode() {
        return this.hashcode;
    }

    public Node[] getChildren() {
        return this.children;
    }

    public Set<Long> getChildrenIdsSet() {
        HashSet<Long> result = new HashSet<Long>();
        for (Node node : this.children) {
            result.add(node.getId());
        }
        return result;
    }

    public Set<Object> getChildrenDataSet() {
        HashSet<Object> result = new HashSet<Object>();
        for (Node node : this.children) {
            result.add(node.getData());
        }
        return result;
    }

    public void addChild(Node child) {
        if (!this.containsChild(child)) {
            int length = this.children.length;
            Node[] newChildren = new Node[length + 1];
            System.arraycopy(this.children, 0, newChildren, 0, length);
            this.children = newChildren;
            this.children[length] = child;
        }
    }

    public Node getChild(long childId) {
        Node result = null;
        for (Node child : this.children) {
            if (child.getId() != childId) continue;
            result = child;
            break;
        }
        return result;
    }

    private boolean containsChild(Node child) {
        for (Node node : this.children) {
            if (!node.equals(child)) continue;
            return true;
        }
        return false;
    }

    public void addHashcode(long hashcode) {
        this.hashcode += hashcode;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "[" + Long.toHexString(this.id) + ", " + Long.toHexString(this.hashcode) + ", " + this.data + ", " + (this.children == null ? "null" : Arrays.asList(this.children)) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id;
    }
}

