/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.comparator.task;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.googlecode.icegem.cacheutils.common.FileService;
import com.googlecode.icegem.cacheutils.comparator.function.GetNodesFunction;
import com.googlecode.icegem.cacheutils.comparator.function.GetNodesFunctionArguments;
import com.googlecode.icegem.cacheutils.comparator.function.GetNodesResultCollector;
import com.googlecode.icegem.cacheutils.comparator.model.Node;
import com.googlecode.icegem.cacheutils.comparator.task.GetNodesTaskArguments;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNodesTask {
    private Pool createLocatorsPool(String locators) {
        PoolFactory poolFactory = PoolManager.createFactory();
        for (String locator : locators.split(",")) {
            String host = locator.substring(0, locator.indexOf("["));
            int port = Integer.parseInt(locator.substring(locator.indexOf("[") + 1, locator.indexOf("]")));
            poolFactory.addLocator(host, port);
        }
        return poolFactory.create("pool-" + locators);
    }

    private Pool createServerPool(String server) {
        String host = server.substring(0, server.indexOf("["));
        int port = Integer.parseInt(server.substring(server.indexOf("[") + 1, server.indexOf("]")));
        return PoolManager.createFactory().addServer(host, port).create("pool-" + host + "-" + port);
    }

    private Set<Node> getNodesPartition(String locators, String regionName, int loadFactor, List<String> packages, long[] ids, int shift) {
        ClientCache cache = new ClientCacheFactory().set("log-level", "none").create();
        ClientRegionFactory clientRegionFactory = cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        Pool pool = this.createLocatorsPool(locators);
        clientRegionFactory.setPoolName(pool.getName());
        Region region = clientRegionFactory.create(regionName);
        GetNodesResultCollector collector = (GetNodesResultCollector)FunctionService.onRegion((Region)region).withCollector((ResultCollector)new GetNodesResultCollector()).withArgs((Serializable)new GetNodesFunctionArguments(loadFactor, packages, ids, shift)).execute((Function)new GetNodesFunction());
        Set nodesSet = (Set)((Object)collector.getResult());
        cache.close();
        return nodesSet;
    }

    private Set<Node> getNodesReplicate(String server, String regionName, int loadFactor, List<String> packages, long[] ids, int shift) {
        ClientCache cache = new ClientCacheFactory().set("log-level", "warning").create();
        ClientRegionFactory clientRegionFactory = cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        Pool pool = this.createServerPool(server);
        clientRegionFactory.setPoolName(pool.getName());
        Region region = clientRegionFactory.create(regionName);
        GetNodesResultCollector collector = (GetNodesResultCollector)FunctionService.onRegion((Region)region).withCollector((ResultCollector)new GetNodesResultCollector()).withArgs((Serializable)new GetNodesFunctionArguments(loadFactor, packages, ids, shift)).execute((Function)new GetNodesFunction());
        Set nodesSet = (Set)((Object)collector.getResult());
        cache.close();
        return nodesSet;
    }

    public static void main(String[] args) throws Throwable {
        try {
            GetNodesTaskArguments arguments = (GetNodesTaskArguments)FileService.readObject(args[0]);
            String mode = arguments.getMode();
            String address = arguments.getAddress();
            String regionName = arguments.getRegionName();
            String filename = arguments.getFilename();
            int loadFactor = arguments.getLoadFactor();
            List<String> packages = arguments.getPackages();
            long[] ids = arguments.getIds();
            int shift = arguments.getShift();
            GetNodesTask calculator = new GetNodesTask();
            Set<Node> nodesSet = null;
            nodesSet = "partition".equals(mode) ? calculator.getNodesPartition(address, regionName, loadFactor, packages, ids, shift) : calculator.getNodesReplicate(address, regionName, loadFactor, packages, ids, shift);
            FileService.writeObject(filename, nodesSet);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }
}

