/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor;

import com.googlecode.icegem.cacheutils.Tool;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.monitor.LoggerNodeEventHandler;
import com.googlecode.icegem.cacheutils.monitor.controller.NodesController;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEventHandler;
import com.googlecode.icegem.cacheutils.monitor.utils.EmailService;
import com.googlecode.icegem.utils.PropertiesHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class MonitorTool
extends Tool {
    private static final String HELP_OPTION = "help";
    private static final String TIMEOUT_OPTION = "timeout";
    private static final String PERIOD_OPTION = "period";
    private static final String LOCATORS_OPTION = "locators";
    private static final String ALL_OPTION = "all";
    private static final String SERVER_OPTION = "server";
    private static final Logger log = Logger.getLogger(MonitorTool.class);
    private static final long DEFAULT_TIMEOUT = 3000L;
    private static final long DEFAULT_PERIOD = 10000L;
    private boolean allOption;
    private String serverHostOption;
    private int serverPortOption;
    private long timeout = 3000L;
    private long period = 10000L;
    private String locators = null;
    private NodesController nodesController;
    private PropertiesHelper propertiesHelper;
    private Timer timer;
    private List<NodeEventHandler> customEventHandlersList = new ArrayList<NodeEventHandler>();

    private void init() {
        try {
            log.info((Object)(Utils.currentDate() + ""));
            log.info((Object)(Utils.currentDate() + "  --------------------------------------------------"));
            log.info((Object)(Utils.currentDate() + "  Monitoring tool started"));
            log.info((Object)(Utils.currentDate() + "  --------------------------------------------------"));
            this.propertiesHelper = new PropertiesHelper("/monitoring.properties");
            this.nodesController = new NodesController(this.propertiesHelper, this.locators, this.timeout);
            this.nodesController.addNodeEventHandler(new LoggerNodeEventHandler());
            for (NodeEventHandler handler : this.customEventHandlersList) {
                this.nodesController.addNodeEventHandler(handler);
            }
            this.timer = new Timer();
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Throwable caught during the initialization", t);
        }
    }

    private void start() {
        try {
            this.timer.schedule((TimerTask)new IsAliveTimerTask(), 0L, this.period);
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Throwable caught during the startup", t);
        }
    }

    public void shutdown() {
        this.nodesController.shutdown();
        this.timer.cancel();
        this.timer = null;
    }

    public static boolean isServerAlive(String host, int port, long timeout) {
        boolean serverAlive = false;
        try {
            PropertiesHelper propertiesHelper = new PropertiesHelper("/monitoring.properties");
            NodesController nodesController = new NodesController(propertiesHelper, null, timeout);
            serverAlive = nodesController.isServerAlive(host, port);
            nodesController.shutdown();
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Throwable caught during the check if the server alive", t);
        }
        return serverAlive;
    }

    public void addNodeEventHandler(NodeEventHandler handler) {
        this.customEventHandlersList.add(handler);
    }

    public void execute(String[] args, boolean debugEnabled, boolean quiet) {
        try {
            this.parseCommandLineArguments(args);
            if (this.serverHostOption != null) {
                boolean serverAlive = MonitorTool.isServerAlive(this.serverHostOption, this.serverPortOption, this.timeout);
                if (serverAlive) {
                    System.out.println("alive");
                    Utils.exitWithSuccess();
                }
                System.out.println("down");
                Utils.exitWithFailure();
            } else if (this.allOption) {
                this.init();
                this.start();
            } else {
                Utils.exitWithFailure("Cannot determine the mode of application");
            }
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Unexpected throwable", t);
        }
    }

    protected void parseCommandLineArguments(String[] commandLineArguments) {
        Options options = this.constructGnuOptions();
        if (commandLineArguments.length < 1) {
            this.printHelp(options);
        }
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, commandLineArguments);
            if (line.hasOption(HELP_OPTION)) {
                this.printHelp(options);
            }
            if (line.hasOption(TIMEOUT_OPTION)) {
                this.timeout = Long.parseLong(line.getOptionValue(TIMEOUT_OPTION));
            }
            if (line.hasOption(PERIOD_OPTION)) {
                this.period = Long.parseLong(line.getOptionValue(PERIOD_OPTION));
            }
            boolean allOptionTemp = line.hasOption(ALL_OPTION);
            String serverOptionTemp = line.getOptionValue(SERVER_OPTION);
            if (serverOptionTemp != null) {
                int indexOfPortStart = serverOptionTemp.indexOf(91);
                int indexOfPortEnd = serverOptionTemp.indexOf(93);
                this.serverHostOption = serverOptionTemp.substring(0, indexOfPortStart);
                String portString = serverOptionTemp.substring(indexOfPortStart + 1, indexOfPortEnd);
                this.serverPortOption = Integer.parseInt(portString);
            } else if (allOptionTemp) {
                this.allOption = allOptionTemp;
                if (line.hasOption(LOCATORS_OPTION)) {
                    this.locators = line.getOptionValue(LOCATORS_OPTION);
                } else {
                    Utils.exitWithFailure("The option --locators should be used when the option --all specified");
                }
            } else {
                Utils.exitWithFailure("The option --server or --all should be specified");
            }
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Throwable caught during the command-line arguments parsing", t);
        }
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("monitor <--help | --server [--timeout] | --all <--locators> [--period] [--timeout] >", options);
        Utils.exitWithFailure();
    }

    protected Options constructGnuOptions() {
        Options gnuOptions = new Options();
        gnuOptions.addOption("s", SERVER_OPTION, true, "Check one server and exit with status 0 if server alive, or with status 1 if server is dead or down. Server should be in format host[port].").addOption("a", ALL_OPTION, false, "Periodically check all the servers related to locators specified in monitoring.properties file").addOption("l", LOCATORS_OPTION, true, "List of locators in format host1[port1],host2[port2]").addOption("p", PERIOD_OPTION, true, "Period between runs, ms. Default value is 10000").addOption("t", TIMEOUT_OPTION, true, "Timeout, ms. Default value is 3000").addOption("h", HELP_OPTION, false, "Print usage information");
        return gnuOptions;
    }

    private class IsAliveTimerTask
    extends TimerTask {
        private IsAliveTimerTask() {
        }

        public void run() {
            try {
                MonitorTool.this.nodesController.update();
            }
            catch (Throwable t) {
                log.error((Object)(Utils.currentDate() + "  Throwable caught"), t);
                t.printStackTrace();
                try {
                    EmailService.getInstance().send(MonitorTool.this.propertiesHelper.getStringProperty("icegem.cacheutils.monitor.email.exception.subject"), MonitorTool.this.propertiesHelper.getStringProperty("icegem.cacheutils.monitor.email.exception.content", new Object[]{t.getMessage(), new Date()}));
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
            }
        }
    }
}

