/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor.controller;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberCacheServer;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.googlecode.icegem.cacheutils.common.AdminService;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.monitor.controller.BufferedNodeEventHandler;
import com.googlecode.icegem.cacheutils.monitor.controller.FunctionExecutionThread;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEvent;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEventHandler;
import com.googlecode.icegem.cacheutils.monitor.controller.model.Node;
import com.googlecode.icegem.cacheutils.monitor.controller.model.NodesContainer;
import com.googlecode.icegem.cacheutils.monitor.utils.EmailService;
import com.googlecode.icegem.utils.PropertiesHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesController {
    private NodesContainer nodes = new NodesContainer();
    private AdminService adminService;
    private PropertiesHelper propertiesHelper;
    private PoolFactory poolFactory;
    private BufferedNodeEventHandler bufferedNodeEventHandler;
    private long timeout;

    public NodesController(PropertiesHelper propertiesHelper, String locators, long timeout) throws Exception {
        this.propertiesHelper = propertiesHelper;
        this.timeout = timeout;
        this.adminService = new AdminService(locators, false);
        this.poolFactory = PoolManager.createFactory();
        this.bufferedNodeEventHandler = new BufferedNodeEventHandler();
        this.nodes.addNodeEventHandler(this.bufferedNodeEventHandler);
    }

    private Set<Integer> extractPortsSet(SystemMember member) throws AdminException {
        SystemMemberCacheServer[] cacheServers;
        HashSet<Integer> portsSet = new HashSet<Integer>();
        SystemMemberCache cache = member.getCache();
        if (cache != null && (cacheServers = cache.getCacheServers()) != null) {
            for (SystemMemberCacheServer cacheServer : cacheServers) {
                portsSet.add(cacheServer.getPort());
            }
        }
        return portsSet;
    }

    private Pool findOrCreatePool(String host, int port) {
        String poolName = Utils.toKey(host, port);
        Pool pool = PoolManager.find((String)poolName);
        if (pool == null) {
            this.poolFactory.reset();
            this.poolFactory.addServer(host, port);
            pool = this.poolFactory.create(poolName);
        }
        return pool;
    }

    private void detectNewNodes() throws AdminException {
        HashSet<Object> allNodesSet = new HashSet<Object>();
        SystemMember[] systemMemberApplications = this.adminService.getAdmin().getSystemMemberApplications();
        allNodesSet.addAll(Arrays.asList(systemMemberApplications));
        CacheVm[] cacheVms = this.adminService.getAdmin().getCacheVms();
        allNodesSet.addAll(Arrays.asList(cacheVms));
        for (SystemMember systemMember : allNodesSet) {
            String host = systemMember.getHost();
            try {
                Set<Integer> portsSet = this.extractPortsSet(systemMember);
                for (int port : portsSet) {
                    Node node = this.nodes.find(host, port);
                    if (node != null) continue;
                    Pool pool = this.findOrCreatePool(host, port);
                    node = new Node(host, port, pool);
                    this.nodes.add(node);
                }
            }
            catch (OperationCancelledException oce) {
            }
        }
    }

    private boolean isOperable(Pool pool) {
        boolean operable = false;
        FunctionExecutionThread functionExecutionThread = new FunctionExecutionThread(pool);
        Utils.execute(functionExecutionThread, this.timeout);
        int zero = functionExecutionThread.getZero();
        if (zero == 0) {
            operable = true;
        }
        return operable;
    }

    private void detectDeadNodes() {
        for (Node node : this.nodes.getAll()) {
            boolean operable = this.isOperable(node.getPool());
            if (operable) {
                this.nodes.markAsAlive(node);
                continue;
            }
            this.nodes.markAsDead(node);
        }
    }

    private void processDeadNodes() {
        for (Node node : this.nodes.getAllDead()) {
            boolean socketAlive = Utils.isSocketAlive(node.getHost(), node.getPort());
            if (socketAlive) continue;
            this.nodes.remove(node);
        }
    }

    private void sendAlertEmail() throws MessagingException {
        List<NodeEvent> eventsList = this.bufferedNodeEventHandler.getAndClearEventslist();
        if (eventsList.size() > 0) {
            EmailService.getInstance().send(this.propertiesHelper.getStringProperty("icegem.cacheutils.monitor.email.alert.subject"), this.propertiesHelper.getStringProperty("icegem.cacheutils.monitor.email.alert.content", new Object[]{this.toContentStringHTML(eventsList), Utils.currentDate()}));
        }
    }

    private String toContentStringHTML(List<NodeEvent> eventslist) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        sb.append("<table style=\"border-collapse:collapse; font: 14px Georgia;\" cellpadding=\"10\" border=\"1\">");
        sb.append("<tr style=\"background: #f0f0f0; text-align: left;\">");
        sb.append("<th>Event date</th>");
        sb.append("<th>Event type</th>");
        sb.append("<th>Node</th>");
        sb.append("</tr>");
        for (NodeEvent event : eventslist) {
            sb.append("<tr>");
            sb.append("<td>").append(Utils.dateToString(event.getCreatedAt())).append("</td>");
            sb.append("<td>").append((Object)event.getType()).append("</td>");
            sb.append("<td>").append(event.getNode()).append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        sb.append("</p>");
        return sb.toString();
    }

    public void update() throws AdminException, MessagingException {
        this.detectNewNodes();
        this.detectDeadNodes();
        this.processDeadNodes();
        this.sendAlertEmail();
    }

    public boolean isServerAlive(String host, int port) {
        Pool pool = this.findOrCreatePool(host, port);
        return this.isOperable(pool);
    }

    public void addNodeEventHandler(NodeEventHandler handler) {
        this.nodes.addNodeEventHandler(handler);
    }

    public void shutdown() {
        this.adminService.close();
    }
}

