/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor.controller.event;

import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEventType;
import com.googlecode.icegem.cacheutils.monitor.controller.model.Node;

public class NodeEvent {
    private long createdAt;
    private Node node;
    private NodeEventType type;

    public NodeEvent(Node node, NodeEventType type) {
        if (node == null || type == null) {
            throw new IllegalArgumentException("The node and type cannot be null");
        }
        this.node = node;
        this.type = type;
        this.createdAt = System.currentTimeMillis();
    }

    public Node getNode() {
        return this.node;
    }

    public NodeEventType getType() {
        return this.type;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.dateToString(this.createdAt)).append("  ").append((Object)this.type).append("  ").append(this.node);
        return sb.toString();
    }
}

