/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor.controller.model;

import com.gemstone.gemfire.cache.client.Pool;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.monitor.controller.model.NodeStatus;

public class Node {
    private String host;
    private int port;
    private Pool pool;
    private NodeStatus status;
    private long statusChangedAt = -1L;

    public Node(String host, int port, Pool pool) {
        this.host = host;
        this.port = port;
        this.pool = pool;
        this.setStatus(NodeStatus.NEW);
    }

    public void markAsAlive() {
        this.setStatus(NodeStatus.ALIVE);
    }

    public void markAsDead() {
        this.setStatus(NodeStatus.DEAD);
    }

    private void setStatus(NodeStatus status) {
        if (!status.equals((Object)this.status)) {
            this.status = status;
            this.statusChangedAt = System.currentTimeMillis();
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Pool getPool() {
        return this.pool;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public long getStatusChangedAt() {
        return this.statusChangedAt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.host).append(":").append(this.port).append(", ");
        sb.append((Object)this.status).append(", ");
        sb.append(Utils.dateToString(this.statusChangedAt));
        sb.append("]");
        return sb.toString();
    }
}

