/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor.controller.model;

import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEvent;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEventHandler;
import com.googlecode.icegem.cacheutils.monitor.controller.event.NodeEventType;
import com.googlecode.icegem.cacheutils.monitor.controller.model.Node;
import com.googlecode.icegem.cacheutils.monitor.controller.model.NodeStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodesContainer {
    private Map<String, Node> socketToNodeMap = new HashMap<String, Node>();
    private List<NodeEventHandler> handlers = new ArrayList<NodeEventHandler>();

    public Node find(String host, int port) {
        return this.socketToNodeMap.get(Utils.toKey(host, port));
    }

    public Set<Node> find(String host) {
        HashSet<Node> resultSet = new HashSet<Node>();
        if (host != null) {
            for (Node node : this.socketToNodeMap.values()) {
                if (!host.equals(node.getHost())) continue;
                resultSet.add(node);
            }
        }
        return resultSet;
    }

    public Set<Node> getAll() {
        return new HashSet<Node>(this.socketToNodeMap.values());
    }

    public Set<Node> getAllNotDead() {
        HashSet<Node> allNotDeadNodesSet = new HashSet<Node>();
        for (Node node : this.socketToNodeMap.values()) {
            if (NodeStatus.DEAD.equals((Object)node.getStatus())) continue;
            allNotDeadNodesSet.add(node);
        }
        return allNotDeadNodesSet;
    }

    public Set<Node> getAllDead() {
        HashSet<Node> allNotDeadNodesSet = new HashSet<Node>();
        for (Node node : this.socketToNodeMap.values()) {
            if (!NodeStatus.DEAD.equals((Object)node.getStatus())) continue;
            allNotDeadNodesSet.add(node);
        }
        return allNotDeadNodesSet;
    }

    public void add(Node node) {
        this.socketToNodeMap.put(Utils.toKey(node), node);
        this.sendEvent(node, NodeEventType.ADDED);
    }

    public void remove(Node node) {
        this.socketToNodeMap.remove(Utils.toKey(node));
        this.sendEvent(node, NodeEventType.REMOVED);
    }

    public void markAsAlive(Node node) {
        if (!NodeStatus.ALIVE.equals((Object)node.getStatus())) {
            this.socketToNodeMap.get(Utils.toKey(node)).markAsAlive();
            this.sendEvent(node, NodeEventType.MARKED_AS_ALIVE);
        }
    }

    public void markAsDead(Node node) {
        if (!NodeStatus.DEAD.equals((Object)node.getStatus())) {
            this.socketToNodeMap.get(Utils.toKey(node)).markAsDead();
            this.sendEvent(node, NodeEventType.MARKED_AS_DEAD);
        }
    }

    public void addNodeEventHandler(NodeEventHandler handler) {
        this.handlers.add(handler);
    }

    private void sendEvent(Node node, NodeEventType type) {
        NodeEvent event = new NodeEvent(node, type);
        for (NodeEventHandler handler : this.handlers) {
            handler.handle(event);
        }
    }
}

