/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.monitor.utils;

import com.googlecode.icegem.utils.PropertiesHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailService {
    private static EmailService instance = null;
    private Session mailSession;
    private PropertiesHelper propertiesHelper = new PropertiesHelper("/monitoring.properties");

    public static EmailService getInstance() {
        if (instance == null) {
            try {
                instance = new EmailService();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot initialize EmailService", e);
            }
        }
        return instance;
    }

    public void send(String subject, String content) throws MessagingException {
        MimeMessage message = this.compose(subject, content, this.propertiesHelper.getStringProperty("mail.to"));
        this.transport(message);
    }

    public void send(String subject, String content, String to) throws MessagingException {
        MimeMessage message = this.compose(subject, content, to);
        this.transport(message);
    }

    private EmailService() throws FileNotFoundException, IOException {
        this.mailSession = Session.getDefaultInstance((Properties)this.propertiesHelper.getProperties(), (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailService.this.propertiesHelper.getStringProperty("mail.user"), EmailService.this.propertiesHelper.getStringProperty("mail.password"));
            }
        });
    }

    private Set<String> csvToSetOfString(String csv) {
        HashSet<String> resultSet = new HashSet<String>();
        if (csv != null && csv.trim().length() > 0) {
            for (String s : csv.split(",")) {
                resultSet.add(s.trim());
            }
        }
        return resultSet;
    }

    private MimeMessage compose(String subject, String content, String to) throws MessagingException {
        MimeMessage message = new MimeMessage(this.mailSession);
        message.setSubject(subject);
        message.setContent((Object)content, "text/html; charset=ISO-8859-1");
        message.setFrom((Address)new InternetAddress(this.propertiesHelper.getStringProperty("mail.from")));
        for (String email : this.csvToSetOfString(to)) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
        }
        return message;
    }

    private void transport(MimeMessage message) throws MessagingException {
        Transport.send((Message)message);
    }
}

