/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import java.util.HashSet;

public class BucketKeysGetterFunction
extends FunctionAdapter {
    public void execute(FunctionContext functionContext) {
        String regionName = (String)((Object[])functionContext.getArguments())[0];
        Integer bucketId = (Integer)((Object[])functionContext.getArguments())[1];
        Region region = CacheFactory.getAnyInstance().getRegion(regionName);
        if (region == null) {
            throw new RuntimeException("there's no such region '" + regionName + "' on this sever");
        }
        if (!PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            throw new RuntimeException("this region '" + regionName + "' is not partitioned");
        }
        HashSet keys = new HashSet();
        try {
            PartitionedRegion pr = (PartitionedRegion)region;
            if (pr.getDataStore().getAllLocalPrimaryBucketIds().contains(bucketId)) {
                keys.addAll(pr.getDataStore().getKeysLocally(bucketId));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error getting keys for bucket " + bucketId, e);
        }
        functionContext.getResultSender().lastResult(keys);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

