/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.AutoConnectionSourceImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.googlecode.icegem.cacheutils.Tool;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.regioncomparator.CollectorTask;
import com.googlecode.icegem.cacheutils.regioncomparator.KeyExtractor;
import com.googlecode.icegem.cacheutils.regioncomparator.PoolResult;
import com.googlecode.icegem.cacheutils.regioncomparator.RegionInfoFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTool
extends Tool {
    private static final Logger log = LoggerFactory.getLogger(CompareTool.class);
    private static String serversOption = "";
    private static String regionName;
    private static List<String> scanPackagesOption;
    private static Properties locatorsProperties;

    @Override
    protected void parseCommandLineArguments(String[] commandLineArguments) {
        Options options = this.constructGnuOptions();
        if (commandLineArguments.length < 1) {
            this.printHelp(options);
            Utils.exitWithSuccess();
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, commandLineArguments);
            if (!line.hasOption("region") || line.hasOption("help") || !line.hasOption("locators") && !line.hasOption("servers")) {
                this.printHelp(options);
                Utils.exitWithSuccess();
            }
            if (line.hasOption("packages")) {
                scanPackagesOption = Arrays.asList(line.getOptionValue("packages").split(","));
            }
            regionName = line.getOptionValue("region");
            if (line.hasOption("locators")) {
                locatorsProperties = line.getOptionProperties("locators");
            }
            if (line.hasOption("servers")) {
                serversOption = line.getOptionValue("servers");
            }
        }
        catch (ParseException exp) {
            System.err.println("Parsing options failed. " + exp.getMessage());
            this.printHelp(options);
            Utils.exitWithSuccess();
        }
    }

    @Override
    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("compare [options]", options);
    }

    @Override
    protected Options constructGnuOptions() {
        Options gnuOptions = new Options();
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Locators of GemFire system. For intra-cluster checking. Example: host1[port1],host2[port2]");
        OptionBuilder.withValueSeparator();
        OptionBuilder.withArgName((String)"cluster=locators");
        OptionBuilder.withLongOpt((String)"locators");
        Option locators = OptionBuilder.create((String)"l");
        gnuOptions.addOption("r", "region", true, "Region path to be compared. Only replicated region could be used. Example: /region1/region2").addOption("s", "servers", true, "Servers of GemFire system. For multi-cluster systems. Example: host1[port1],host2[port2]").addOption(locators).addOption("c", "packages", true, "Enumerate packages to scan for @AutoSerializable model classes. Delimiter is a comma sign.").addOption("h", "help", false, "Print usage information");
        return gnuOptions;
    }

    @Override
    public void execute(String[] args, boolean debugEnabled, boolean quiet) {
        Pool sourcePool;
        AdminDistributedSystem adminDs = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)AdminDistributedSystemFactory.defineDistributedSystem());
        adminDs.connect();
        this.parseCommandLineArguments(args);
        ArrayList<Pool> poolList = new ArrayList<Pool>();
        if (serversOption != null && serversOption.length() > 0) {
            for (String serverOption : serversOption.split(",")) {
                String serverHost = serverOption.substring(0, serverOption.indexOf("["));
                String serverPort = serverOption.substring(serverOption.indexOf("[") + 1, serverOption.indexOf("]"));
                poolList.add(PoolManager.createFactory().addServer(serverHost, Integer.parseInt(serverPort)).create("poolTo" + serverHost + serverPort));
            }
        }
        if (locatorsProperties != null && !locatorsProperties.isEmpty()) {
            for (Object poolOption : locatorsProperties.keySet()) {
                String locator = (String)locatorsProperties.get(poolOption);
                String serverHost = locator.substring(0, locator.indexOf("["));
                String serverPort = locator.substring(locator.indexOf("[") + 1, locator.indexOf("]"));
                poolList.add(PoolManager.createFactory().addLocator(serverHost, Integer.parseInt(serverPort)).create("poolTo" + serverHost + serverPort));
            }
        }
        boolean partitioned = false;
        ArrayList<ServerLocation> serverFromPool = new ArrayList<ServerLocation>();
        ArrayList<Pool> emptyPools = new ArrayList<Pool>();
        for (Pool pool : poolList) {
            List<Object> allServers = null;
            if (!pool.getLocators().isEmpty()) {
                allServers = ((AutoConnectionSourceImpl)((PoolImpl)pool).getConnectionSource()).findAllServers();
            } else if (!pool.getServers().isEmpty()) {
                allServers = Arrays.asList(((PoolImpl)pool).getConnectionSource().findServer(Collections.emptySet()));
            }
            if (allServers != null) {
                serverFromPool.addAll(allServers);
                continue;
            }
            log.info("not found servers on locator {}", (Object)pool);
            emptyPools.add(pool);
        }
        poolList.removeAll(emptyPools);
        if (serverFromPool.size() == 0) {
            log.info("no servers available");
            return;
        }
        this.printServerLocationDetails(serverFromPool);
        if (!partitioned) {
            int randomServerLocation = new Random().nextInt(serverFromPool.size());
            sourcePool = PoolManager.createFactory().addServer(((ServerLocation)serverFromPool.get(randomServerLocation)).getHostName(), ((ServerLocation)serverFromPool.get(randomServerLocation)).getPort()).create("target");
        } else {
            sourcePool = (Pool)poolList.get(0);
            poolList.remove(0);
        }
        FunctionService.registerFunction((Function)new RegionInfoFunction());
        ResultCollector regionInfoResult = FunctionService.onServers((Pool)sourcePool).withArgs((Serializable)((Object)regionName)).execute((Function)new RegionInfoFunction());
        HashMap regionInfo = (HashMap)((ArrayList)regionInfoResult.getResult()).get(0);
        System.out.println("region info: " + regionInfo);
        int totalNumBuckets = (Integer)regionInfo.get("totalNumBuckets");
        System.out.println("total keys' batch counts is " + totalNumBuckets);
        KeyExtractor keyExtractor = new KeyExtractor(regionName, sourcePool, partitioned, totalNumBuckets);
        HashMap<String, Map> clusterDifference = new HashMap<String, Map>();
        ArrayList taskResults = new ArrayList();
        ArrayList<Future<PoolResult>> collectTasks = new ArrayList<Future<PoolResult>>(poolList.size());
        ExecutorService executorService = Executors.newFixedThreadPool(poolList.size());
        while (keyExtractor.hasKeys()) {
            Set keys = keyExtractor.getNextKeysBatch();
            System.out.println("keys to check: " + keys);
            for (Pool pool : poolList) {
                collectTasks.add(executorService.submit(new CollectorTask(keys, pool, regionName)));
            }
            System.out.println("active tasks: " + collectTasks.size());
            try {
                for (Future future : collectTasks) {
                    taskResults.add(future.get());
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (ExecutionException ee) {
                ee.printStackTrace();
            }
            collectTasks.clear();
            System.out.println("compare contents..");
            HashMap sourceData = new HashMap();
            FutureTask<PoolResult> futureTask = new FutureTask<PoolResult>(new CollectorTask(keys, sourcePool, regionName));
            futureTask.run();
            try {
                PoolResult rc = futureTask.get();
                List poolResult = (List)((Object)rc.getResultCollector().getResult());
                for (Object singleResult : poolResult) {
                    sourceData.putAll((Map)((HashMap)singleResult).get("map"));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error getting key-hash from pool: " + sourcePool, e);
            }
            System.out.println("source data is: " + sourceData);
            for (PoolResult taskResultFromPool : taskResults) {
                ArrayList poolResult = (ArrayList)taskResultFromPool.getResultCollector().getResult();
                if (!partitioned) {
                    for (Object resultFromMember : poolResult) {
                        HashMap result = (HashMap)resultFromMember;
                        String memberId = (String)result.get("memberId");
                        if (regionInfo.get("id").equals(result.get("memberId"))) continue;
                        Map<String, Set> aggregationInfo = CompareTool.compareAndAggregate(sourceData, (HashMap)result.get("map"));
                        System.out.println("result of comparing is: " + aggregationInfo);
                        if (!clusterDifference.containsKey(memberId)) {
                            aggregationInfo.put("absentKeys", new HashSet());
                            clusterDifference.put(memberId, aggregationInfo);
                            continue;
                        }
                        Map difference = (Map)clusterDifference.get(memberId);
                        ((Set)difference.get("absentKeys")).addAll((Set)result.get("absentKeys"));
                        ((Set)difference.get("diffValues")).addAll(aggregationInfo.get("diffValues"));
                        clusterDifference.put(memberId, difference);
                    }
                    continue;
                }
                HashMap targetData = new HashMap();
                HashSet absentKeysFromPool = new HashSet();
                for (Object resultFromMember : poolResult) {
                    targetData.putAll((Map)((HashMap)resultFromMember).get("map"));
                    absentKeysFromPool.addAll((Set)((HashMap)resultFromMember).get("absentKeys"));
                }
                Map<String, Set> aggregationInfo = CompareTool.compareAndAggregate(sourceData, targetData);
                System.out.println("result of comparing is: " + aggregationInfo);
                String keyForPartitionRegionType = taskResultFromPool.getPool().toString();
                if (!clusterDifference.containsKey(keyForPartitionRegionType)) {
                    clusterDifference.put(keyForPartitionRegionType, aggregationInfo);
                    continue;
                }
                Map difference = (Map)clusterDifference.get(keyForPartitionRegionType);
                ((Set)difference.get("absentKeys")).addAll(aggregationInfo.get("absentKeys"));
                ((Set)difference.get("diffValues")).addAll(aggregationInfo.get("diffValues"));
                clusterDifference.put(keyForPartitionRegionType, difference);
            }
            taskResults.clear();
        }
        System.out.println("____________________________");
        System.out.println("difference: ");
        System.out.println(clusterDifference);
        executorService.shutdown();
        adminDs.disconnect();
    }

    private static Map<String, Set> compareAndAggregate(Map sourceMap, Map targetMap) {
        System.out.println("compare maps");
        System.out.println("source: " + sourceMap);
        System.out.println("target: " + targetMap);
        HashMap<String, Set> aggregationInfo = new HashMap<String, Set>();
        HashSet keysForDiffValues = new HashSet();
        for (Object regionKey : targetMap.keySet()) {
            if (targetMap.get(regionKey).equals(sourceMap.get(regionKey))) continue;
            keysForDiffValues.add(regionKey);
        }
        aggregationInfo.put("diffValues", keysForDiffValues);
        return aggregationInfo;
    }

    private void printServerLocationDetails(List<ServerLocation> serverLocationList) {
        for (ServerLocation server : serverLocationList) {
            System.out.println("host: " + server.getHostName());
            System.out.println("port: " + server.getPort());
            System.out.println("----------------------");
        }
    }

    static {
        locatorsProperties = new Properties();
    }
}

