/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GetKeysFunction
extends FunctionAdapter {
    private static final long serialVersionUID = -1467135292875589062L;
    private static int BATCH_SIZE = 3;

    public void execute(FunctionContext functionContext) {
        HashMap args = (HashMap)functionContext.getArguments();
        String regionName = (String)args.get("regionName");
        Region region = CacheFactory.getAnyInstance().getRegion(regionName);
        if (region == null) {
            functionContext.getResultSender().lastResult(new HashSet());
            return;
        }
        int bucket = 0;
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            bucket = (Integer)args.get("bucket");
            PartitionedRegion pr = (PartitionedRegion)region;
            HashSet keys = new HashSet();
            if (pr.getDataStore().getAllLocalPrimaryBucketIds().contains(bucket)) {
                try {
                    keys.addAll(pr.getDataStore().getKeysLocally(Integer.valueOf(bucket)));
                }
                catch (Exception e) {
                    throw new RuntimeException("error getting local keys for bucket " + bucket, e);
                }
            }
            functionContext.getResultSender().lastResult(keys);
            return;
        }
        Set keys = region.keySet();
        Iterator iterator = keys.iterator();
        HashSet keysBatch = new HashSet(BATCH_SIZE);
        while (iterator.hasNext()) {
            keysBatch.add(iterator.next());
            if ((keysBatch.size() + 1) % BATCH_SIZE != 0) continue;
            functionContext.getResultSender().sendResult(keysBatch);
            keysBatch = new HashSet(BATCH_SIZE);
        }
        functionContext.getResultSender().lastResult(keysBatch);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

