/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.AutoConnectionSourceImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.googlecode.icegem.cacheutils.regioncomparator.CollectorTask;
import com.googlecode.icegem.cacheutils.regioncomparator.KeyExtractor;
import com.googlecode.icegem.cacheutils.regioncomparator.PoolResult;
import com.googlecode.icegem.cacheutils.regioncomparator.RegionInfoFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashCodeCollector {
    private static Logger logger = LoggerFactory.getLogger(HashCodeCollector.class);
    private static String REGION_NAME = "data";

    public static void main(String[] args) throws AdminException {
        Pool sourcePool;
        AdminDistributedSystem adminDs = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)AdminDistributedSystemFactory.defineDistributedSystem());
        adminDs.connect();
        Pool poolForCluster1 = PoolManager.createFactory().addLocator("localhost", 10330).create("cluster1");
        Pool poolForCluster2 = PoolManager.createFactory().addLocator("localhost", 10332).create("cluster2");
        ArrayList<Pool> poolList = new ArrayList<Pool>();
        poolList.add(poolForCluster1);
        poolList.add(poolForCluster2);
        boolean partitioned = true;
        ArrayList serverFromPool = new ArrayList();
        ArrayList<Pool> emptyPools = new ArrayList<Pool>();
        for (Pool pool : poolList) {
            List<Object> allServers = null;
            if (!pool.getLocators().isEmpty()) {
                allServers = ((AutoConnectionSourceImpl)((PoolImpl)pool).getConnectionSource()).findAllServers();
            } else if (!pool.getServers().isEmpty()) {
                allServers = Arrays.asList(((PoolImpl)pool).getConnectionSource().findServer(Collections.emptySet()));
            }
            if (allServers != null) {
                serverFromPool.addAll(allServers);
                continue;
            }
            logger.info("not found servers on locator {}", (Object)pool);
            emptyPools.add(pool);
        }
        poolList.removeAll(emptyPools);
        if (serverFromPool.size() == 0) {
            logger.info("no servers available");
            return;
        }
        for (ServerLocation server : serverFromPool) {
            System.out.println("host: " + server.getHostName());
            System.out.println("port: " + server.getPort());
            System.out.println("----------------------");
        }
        if (!partitioned) {
            int randomServerLocation = new Random().nextInt(serverFromPool.size());
            sourcePool = PoolManager.createFactory().addServer(((ServerLocation)serverFromPool.get(randomServerLocation)).getHostName(), ((ServerLocation)serverFromPool.get(randomServerLocation)).getPort()).create("target");
        } else {
            sourcePool = (Pool)poolList.get(0);
            poolList.remove(0);
        }
        FunctionService.registerFunction((Function)new RegionInfoFunction());
        ResultCollector regionInfoResult = FunctionService.onServers((Pool)sourcePool).withArgs((Serializable)((Object)REGION_NAME)).execute((Function)new RegionInfoFunction());
        HashMap regionInfo = (HashMap)((ArrayList)regionInfoResult.getResult()).get(0);
        System.out.println("region info: " + regionInfo);
        int totalNumBuckets = (Integer)regionInfo.get("totalNumBuckets");
        System.out.println("total keys' batch counts is " + totalNumBuckets);
        KeyExtractor keyExtractor = new KeyExtractor(REGION_NAME, sourcePool, partitioned, totalNumBuckets);
        HashMap<String, Map> clusterDifference = new HashMap<String, Map>();
        ArrayList taskResults = new ArrayList();
        ArrayList<Future<PoolResult>> collectTasks = new ArrayList<Future<PoolResult>>(poolList.size());
        ExecutorService executorService = Executors.newFixedThreadPool(poolList.size());
        while (keyExtractor.hasKeys()) {
            Set keys = keyExtractor.getNextKeysBatch();
            System.out.println("keys to check: " + keys);
            for (Pool pool : poolList) {
                collectTasks.add(executorService.submit(new CollectorTask(keys, pool, REGION_NAME)));
            }
            System.out.println("active tasks: " + collectTasks.size());
            try {
                for (Future future : collectTasks) {
                    taskResults.add(future.get());
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (ExecutionException ee) {
                ee.printStackTrace();
            }
            collectTasks.clear();
            System.out.println("compare contents..");
            HashMap originalData = new HashMap();
            FutureTask<PoolResult> futureTask = new FutureTask<PoolResult>(new CollectorTask(keys, sourcePool, REGION_NAME));
            futureTask.run();
            try {
                PoolResult rc = futureTask.get();
                List poolResult = (List)((Object)rc.getResultCollector().getResult());
                for (Object singleResult : poolResult) {
                    originalData.putAll((Map)((HashMap)singleResult).get("map"));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error getting key-hash from pool: " + sourcePool, e);
            }
            System.out.println("original data is: " + originalData);
            for (PoolResult taskResultFromPool : taskResults) {
                ArrayList poolResult = (ArrayList)taskResultFromPool.getResultCollector().getResult();
                if (!partitioned) {
                    for (Object resultFromMember : poolResult) {
                        HashMap result = (HashMap)resultFromMember;
                        if (regionInfo.get("id").equals(result.get("memberId"))) continue;
                        String memberId = (String)result.get("memberId");
                        HashMap memberData = (HashMap)result.get("map");
                        HashMap memberDataCopy = new HashMap();
                        memberDataCopy.putAll(memberData);
                        memberDataCopy.keySet().retainAll(originalData.keySet());
                        HashMap aggregationInfo = new HashMap();
                        HashSet keysForDiffValues = new HashSet();
                        HashSet absentKeys = new HashSet();
                        for (Object regionKey : memberDataCopy.keySet()) {
                            if (memberDataCopy.get(regionKey).equals(originalData.get(regionKey))) continue;
                            keysForDiffValues.add(regionKey);
                        }
                        aggregationInfo.put("diffValues", keysForDiffValues);
                        memberData.keySet().removeAll(memberDataCopy.keySet());
                        absentKeys.addAll(memberData.keySet());
                        absentKeys.addAll((HashSet)result.get("absentKeys"));
                        aggregationInfo.put("absentKeys", absentKeys);
                        if (!clusterDifference.containsKey(memberId)) {
                            clusterDifference.put(memberId, aggregationInfo);
                            continue;
                        }
                        Map difference = (Map)clusterDifference.get(memberId);
                        ((Set)difference.get("absentKeys")).addAll((Collection)aggregationInfo.get("absentKeys"));
                        ((Set)difference.get("diffValues")).addAll((Collection)aggregationInfo.get("diffValues"));
                        clusterDifference.put(memberId, difference);
                    }
                    continue;
                }
                HashMap targetMap = new HashMap();
                HashSet absentPoolKeys = new HashSet();
                for (Object memberResult : poolResult) {
                    targetMap.putAll((Map)((HashMap)memberResult).get("map"));
                    absentPoolKeys.addAll((Set)((HashMap)memberResult).get("absentKeys"));
                }
                HashMap memberDataCopy = new HashMap();
                memberDataCopy.putAll(targetMap);
                memberDataCopy.keySet().retainAll(originalData.keySet());
                HashMap aggregationInfo = new HashMap();
                HashSet keysForDiffValues = new HashSet();
                HashSet<Object> absentKeys = new HashSet<Object>();
                for (Object regionKey : memberDataCopy.keySet()) {
                    if (memberDataCopy.get(regionKey).equals(originalData.get(regionKey))) continue;
                    keysForDiffValues.add(regionKey);
                }
                aggregationInfo.put("diffValues", keysForDiffValues);
                targetMap.keySet().removeAll(memberDataCopy.keySet());
                absentKeys.addAll(targetMap.keySet());
                absentKeys.addAll(absentPoolKeys);
                if (!clusterDifference.containsKey(taskResultFromPool.getPool().toString())) {
                    clusterDifference.put(taskResultFromPool.getPool().toString(), aggregationInfo);
                    continue;
                }
                Map difference = (Map)clusterDifference.get(taskResultFromPool.getPool().toString());
                ((Set)difference.get("diffValues")).addAll((Collection)aggregationInfo.get("diffValues"));
                clusterDifference.put(taskResultFromPool.getPool().toString(), difference);
            }
            taskResults.clear();
        }
        System.out.println("____________________________");
        System.out.println("difference: ");
        System.out.println(clusterDifference);
        executorService.shutdown();
        adminDs.disconnect();
    }

    private static void aggregateSingleClusterMemberData(List<ResultCollector> taskResults) {
        for (ResultCollector singleCluster : taskResults) {
            List membersResult = (List)((Object)singleCluster.getResult());
            for (Object resultFromNode : membersResult) {
                System.out.print(((HashMap)resultFromNode).get("ds") + ":");
            }
            System.out.println();
        }
    }
}

