/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashCodeCollectorFunction
extends FunctionAdapter {
    private static Logger logger = LoggerFactory.getLogger(HashCodeCollectorFunction.class);
    private static final long serialVersionUID = -7410041026699443297L;

    public void execute(FunctionContext functionContext) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap hashCodeMap = new HashMap();
        HashSet absentKeys = new HashSet();
        result.put("map", hashCodeMap);
        result.put("absentKeys", absentKeys);
        logger.debug("start executing function..");
        System.out.println("start executing function..");
        String memberId = CacheFactory.getAnyInstance().getDistributedSystem().getDistributedMember().getId();
        result.put("memberId", memberId);
        String regionName = (String)((HashMap)functionContext.getArguments()).get("regionName");
        Region checkingRegion = CacheFactory.getAnyInstance().getRegion(regionName);
        if (checkingRegion == null) {
            functionContext.getResultSender().lastResult(result);
            return;
        }
        HashSet keySet = (HashSet)((HashMap)functionContext.getArguments()).get("keys");
        if (PartitionRegionHelper.isPartitionedRegion((Region)checkingRegion)) {
            logger.debug("region is partitioned");
            System.out.println("region is partitioned");
            Region localRegion = PartitionRegionHelper.getLocalPrimaryData((Region)checkingRegion);
            for (Object key : keySet) {
                if (localRegion.containsKey(key)) {
                    hashCodeMap.put(key, localRegion.get(key).hashCode());
                    continue;
                }
                absentKeys.add(key);
            }
        } else {
            logger.debug("region isn't partitioned");
            System.out.println("region isn't partitioned");
            for (Object key : keySet) {
                if (checkingRegion.containsKey(key)) {
                    hashCodeMap.put(key, checkingRegion.get(key).hashCode());
                    continue;
                }
                absentKeys.add(key);
            }
        }
        logger.trace("local map is: " + hashCodeMap);
        System.out.println("local map is " + hashCodeMap);
        functionContext.getResultSender().lastResult(result);
        logger.debug("stop executing function..");
        System.out.println("stop executing");
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

