/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.googlecode.icegem.cacheutils.regioncomparator.GetKeysFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class KeyExtractor {
    private String regionName;
    private Pool sourcePool;
    private boolean isPartitioned;
    private int totalBatches;
    private int currentBatch = 0;
    private List<Set> keysBatch;

    KeyExtractor(String regionName, Pool sourcePool, boolean isPartitioned, int totalBatches) {
        assert (regionName != null);
        assert (sourcePool != null);
        this.regionName = regionName;
        this.sourcePool = sourcePool;
        this.isPartitioned = isPartitioned;
        this.totalBatches = totalBatches;
        this.keysBatch = new ArrayList<Set>();
        if (!isPartitioned) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("regionName", regionName);
            ResultCollector resultCollector = FunctionService.onServer((Pool)sourcePool).withArgs(args).execute((Function)new GetKeysFunction());
            for (Object keys : (List)((Object)resultCollector.getResult())) {
                this.keysBatch.add((Set)keys);
            }
        }
    }

    public boolean hasKeys() {
        return this.currentBatch <= this.totalBatches;
    }

    public Set getNextKeysBatch() {
        HashSet result = new HashSet();
        if (this.isPartitioned) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("regionName", this.regionName);
            while (result.isEmpty() && this.hasKeys()) {
                args.put("bucket", this.currentBatch);
                ++this.currentBatch;
                List keySearchResult = (List)((Object)FunctionService.onServers((Pool)this.sourcePool).withArgs(args).execute((Function)new GetKeysFunction()).getResult());
                for (Object keySearchResultForMember : keySearchResult) {
                    result.addAll((Set)keySearchResultForMember);
                }
            }
            System.out.println("found keys for bucket " + this.currentBatch);
            return result;
        }
        return this.keysBatch.get(this.currentBatch++);
    }
}

