/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.execute.DefaultResultCollector;
import com.googlecode.icegem.cacheutils.regioncomparator.RegionCompareFunction;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionComparator {
    private static final Logger log = LoggerFactory.getLogger(RegionComparator.class);

    public List compareSingleCluster(Object[] keySetOnServer, String locators, String regionPath) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", locators);
        props.setProperty("log-file", "comparator-member.log");
        DistributedSystem system = DistributedSystem.connect((Properties)props);
        Cache cache = new CacheFactory().set("mcast-port", "0").set("locators", locators).set("log-file", "comparator-member.log").create();
        Object[] args = new Object[]{regionPath, keySetOnServer};
        Execution execution = FunctionService.onMembers((DistributedSystem)system).withArgs((Serializable)args).withCollector((ResultCollector)new DefaultResultCollector());
        ResultCollector rc = execution.execute((Function)new RegionCompareFunction());
        List result = (List)((Object)rc.getResult());
        String localId = system.getDistributedMember().getId();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object[][] res = (Object[][])iterator.next();
            if (!res[3][0].equals(localId)) continue;
            iterator.remove();
        }
        cache.close();
        system.disconnect();
        return result;
    }

    public List compareDifferentClusters(Region<?, ?> region) {
        Object[] args = new Object[]{region.getFullPath(), region.keySetOnServer().toArray()};
        FunctionService.registerFunction((Function)new RegionCompareFunction());
        Execution execution = FunctionService.onServers((RegionService)region.getCache()).withArgs((Serializable)args).withCollector((ResultCollector)new DefaultResultCollector());
        ResultCollector rc = execution.execute((Function)new RegionCompareFunction());
        return (List)((Object)rc.getResult());
    }
}

