/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RegionCompareFunction
extends FunctionAdapter {
    private static final long serialVersionUID = 4569716549835836666L;

    public void execute(FunctionContext fc) {
        Region region = null;
        try {
            Object[] argsArray = (Object[])fc.getArguments();
            String regionPath = (String)argsArray[0];
            Object[] keySetOnServer = (Object[])argsArray[1];
            Cache cache = CacheFactory.getAnyInstance();
            region = cache.getRegion(regionPath);
            if (region != null) {
                HashMap distributedEntriesMap = new HashMap(region.getAll(Arrays.asList(keySetOnServer)));
                Object[] localEntries = region.entrySet().toArray();
                HashMap localEntriesMap = new HashMap();
                for (Object entry : localEntries) {
                    localEntriesMap.put(((Map.Entry)entry).getKey(), ((Map.Entry)entry).getValue());
                }
                Object[][] result = this.compareRegions(distributedEntriesMap, localEntriesMap, region);
                fc.getResultSender().lastResult((Serializable)result);
            } else {
                Object[][] result = new Object[4][1];
                result[0][0] = null;
                result[1][0] = null;
                result[2][0] = null;
                result[3][0] = cache.getDistributedSystem().getDistributedMember().getId();
                fc.getResultSender().lastResult((Serializable)result);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Object[][] result = new Object[4][1];
            result[0][0] = null;
            result[1][0] = null;
            result[2][0] = null;
            result[3][0] = "Exception " + ex.getMessage() + ex.getCause().getMessage() + " was thrown on node " + region.getCache().getDistributedSystem().getDistributedMember().getId();
            fc.getResultSender().lastResult((Serializable)result);
        }
    }

    private Object[][] compareRegions(Map distributedEntries, Map localEntries, Region region) {
        if (((Object)distributedEntries).equals(localEntries)) {
            Object[][] result = new Object[4][1];
            result[0][0] = null;
            result[1][0] = null;
            result[2][0] = null;
            result[3][0] = region.getCache().getDistributedSystem().getDistributedMember().getId();
            return result;
        }
        HashSet missing = new HashSet(distributedEntries.keySet());
        missing.removeAll(localEntries.keySet());
        HashSet extra = new HashSet(localEntries.keySet());
        extra.removeAll(distributedEntries.keySet());
        HashSet different = new HashSet();
        distributedEntries.keySet().removeAll(missing);
        localEntries.keySet().removeAll(extra);
        for (Object key : distributedEntries.keySet()) {
            if (distributedEntries.get(key).equals(localEntries.get(key))) continue;
            different.add(key);
        }
        Object[][] result = new Object[4][1];
        result[0][0] = missing.toArray();
        result[1][0] = extra.toArray();
        result[2][0] = different.toArray();
        result[3][0] = region.getCache().getDistributedSystem().getDistributedMember().getId();
        return result;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

