/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.regioncomparator;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import java.util.HashMap;

public class RegionInfoFunction
extends FunctionAdapter {
    private static int BATCH_SIZE = 3;
    private static final long serialVersionUID = -7733341987189336659L;

    public void execute(FunctionContext functionContext) {
        String regionName = (String)((Object)functionContext.getArguments());
        Region region = CacheFactory.getAnyInstance().getRegion(regionName);
        if (region == null) {
            System.out.println("region " + regionName + " doesn't exist");
            functionContext.getResultSender().lastResult(new HashMap());
        }
        HashMap<String, Object> regionInfo = new HashMap<String, Object>();
        boolean isPartitioned = false;
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            isPartitioned = true;
        }
        regionInfo.put("isPartitioned", isPartitioned);
        regionInfo.put("id", CacheFactory.getAnyInstance().getDistributedSystem().getDistributedMember().getId());
        if (isPartitioned) {
            int totalNumBuckets = PartitionRegionHelper.getPartitionRegionInfo((Region)region).getConfiguredBucketCount();
            regionInfo.put("totalNumBuckets", totalNumBuckets);
        } else if (region.keySet().size() > 0) {
            regionInfo.put("totalNumBuckets", region.keySet().size() / BATCH_SIZE + 1);
        } else {
            regionInfo.put("totalNumBuckets", 0);
        }
        functionContext.getResultSender().lastResult(regionInfo);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

