/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.replication;

import com.googlecode.icegem.cacheutils.Tool;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.cacheutils.replication.ReplicationProcessor;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CheckReplicationTool
extends Tool {
    private static final String TIMEOUT_OPTION = "timeout";
    private static final String CLUSTER_OPTION = "cluster";
    private static final String REGION_OPTION = "region";
    private static final String HELP_OPTION = "help";
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static final long DELTA_TIMEOUT = 10000L;
    private static final String DEFAULT_REGION_NAME = "proxy";
    private static long timeout = 60000L;
    private static String regionName = "proxy";
    private Properties clustersProperties;
    private boolean debugEnabled;

    public void execute(String[] args, boolean debugEnabled, boolean quiet) {
        try {
            this.debugEnabled = debugEnabled;
            this.debug("CheckReplicationTool#execute(String[]): args = " + Arrays.asList(args));
            this.parseCommandLineArguments(args);
            System.out.println("Connecting...");
            this.debug("CheckReplicationTool#execute(String[]): Creating CheckReplicationTool.ProcessorTask with parameters: clustersProperties = " + this.clustersProperties + ", timeout = " + timeout + ", regionName = " + regionName);
            ProcessorTask task = new ProcessorTask(this.clustersProperties, timeout, regionName, debugEnabled, quiet);
            this.debug("CheckReplicationTool#execute(String[]): Starting CheckReplicationTool.ProcessorTask");
            Utils.execute(task, timeout + 10000L);
            int exitCode = task.getExitCode();
            this.debug("CheckReplicationTool#execute(String[]): CheckReplicationTool.ProcessorTask finished with exitCode = " + exitCode);
            if (exitCode == 0) {
                Utils.exitWithSuccess();
            }
            Utils.exitWithFailure();
        }
        catch (Throwable t) {
            this.debug("CheckReplicationTool#execute(String[]): Throwable caught with message = " + t.getMessage(), t);
            Utils.exitWithFailure("Unexpected throwable", t);
        }
    }

    protected void parseCommandLineArguments(String[] commandLineArguments) {
        Options options = this.constructGnuOptions();
        if (commandLineArguments.length < 1) {
            this.printHelp(options);
        }
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, commandLineArguments);
            if (line.hasOption(HELP_OPTION)) {
                this.printHelp(options);
            }
            if (line.hasOption(REGION_OPTION)) {
                regionName = line.getOptionValue(REGION_OPTION);
            }
            if (line.hasOption(TIMEOUT_OPTION)) {
                String timeoutString = line.getOptionValue(TIMEOUT_OPTION);
                timeout = Long.parseLong(timeoutString);
            }
            if (line.hasOption(CLUSTER_OPTION)) {
                this.clustersProperties = line.getOptionProperties(CLUSTER_OPTION);
                if (this.clustersProperties.keySet().size() < 2) {
                    Utils.exitWithFailure("At least two clusters should be defined");
                }
            } else {
                Utils.exitWithFailure("No clusters defined");
            }
        }
        catch (Throwable t) {
            Utils.exitWithFailure("Throwable caught during the command-line arguments parsing", t);
        }
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("check-replication [options]", options);
        Utils.exitWithFailure();
    }

    protected Options constructGnuOptions() {
        Options gnuOptions = new Options();
        gnuOptions.addOption("t", TIMEOUT_OPTION, true, "Timeout, ms. Default timeout is 60000").addOption("r", REGION_OPTION, true, "The name of region for this test. Default name is \"proxy\"").addOption("h", HELP_OPTION, false, "Print usage information");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Cluster name and list of its locators. There should be at least two clusters. Example: -c cluster1=host1[port1],host2[port2] -c cluster2=host3[port3]");
        OptionBuilder.withValueSeparator();
        OptionBuilder.withArgName((String)"cluster=locators");
        OptionBuilder.withLongOpt((String)CLUSTER_OPTION);
        Option locatorsOption = OptionBuilder.create((String)"c");
        gnuOptions.addOption(locatorsOption);
        return gnuOptions;
    }

    private void debug(String message) {
        this.debug(message, null);
    }

    private void debug(String message, Throwable t) {
        if (this.debugEnabled) {
            System.err.println("0 [CheckReplicationTool] " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private class ProcessorTask
    implements Runnable {
        private int exitCode;
        private Properties clustersProperties;
        private long timeout;
        private String regionName;
        private boolean debugEnabled;
        private boolean quiet;

        public ProcessorTask(Properties clustersProperties, long timeout, String regionName, boolean debugEnabled, boolean quiet) {
            this.clustersProperties = clustersProperties;
            this.timeout = timeout;
            this.regionName = regionName;
            this.debugEnabled = debugEnabled;
            this.quiet = quiet;
        }

        public void run() {
            ReplicationProcessor processor = new ReplicationProcessor(this.clustersProperties, this.timeout, this.regionName, this.debugEnabled, this.quiet);
            this.exitCode = 1;
            try {
                this.exitCode = processor.process();
            }
            catch (Throwable t) {
                CheckReplicationTool.this.debug("CheckReplicationTool.ProcessorTask#run(): Throwable caught with message = " + t.getMessage(), t);
            }
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

