/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.replication;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.googlecode.icegem.cacheutils.common.Utils;
import com.googlecode.icegem.utils.PropertiesHelper;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class GuestNode {
    private static final String GEMFIRE_PREFIX = "gemfire.";
    private static final int CHECK_PERIOD = 50;
    private static final String KEY_PREFIX = "check-replication-";
    private static final String KEY_POSTFIX_STARTED_AT = "-startedAt";
    private static final String KEY_POSTFIX_SENT_AT = "-sentAt";
    private static final String KEY_POSTFIX_DURATION = "-receivedAt";
    private String localClusterName;
    private ClientCache clientCache;
    private Region<String, Long> region;
    private String regionName;
    private Properties clustersProperties;
    private boolean debugEnabled;
    private boolean quiet;
    private long processingStartedAt;

    private GuestNode(String cluster, Properties clustersProperties, String regionName, boolean debugEnabled, boolean quiet, long processingStartedAt) {
        this.debug("GuestNode#GuestNode(String, Properties, String, String, String): Creating instance with parameters: cluster = " + cluster + ", clustersProperties = " + clustersProperties + ", regionName = " + regionName);
        this.localClusterName = cluster;
        this.clustersProperties = clustersProperties;
        this.regionName = regionName;
        this.debugEnabled = debugEnabled;
        this.quiet = quiet;
        this.processingStartedAt = processingStartedAt;
        this.debug("GuestNode#GuestNode(String, Properties, String, String, String): Creating RelationsController");
        this.init();
    }

    private String createStartedAtKey(String clusterName) {
        return KEY_PREFIX + clusterName + KEY_POSTFIX_STARTED_AT;
    }

    private String createSentAtKey(String clusterName) {
        return KEY_PREFIX + clusterName + KEY_POSTFIX_SENT_AT;
    }

    private String createReceivedAtKey(String fromClusterName, String toClusterName) {
        return KEY_PREFIX + fromClusterName + "-" + toClusterName + KEY_POSTFIX_DURATION;
    }

    private void init() {
        try {
            String[] locatorsArray;
            this.debug("GuestNode#init(): Creating Cache");
            ClientCacheFactory clientCacheFactory = new ClientCacheFactory();
            Properties gemfireProperties = PropertiesHelper.filterProperties((Properties)System.getProperties(), (String)GEMFIRE_PREFIX);
            for (Object keyObject : gemfireProperties.keySet()) {
                String key = (String)keyObject;
                String value = gemfireProperties.getProperty(key);
                String name = key.substring(GEMFIRE_PREFIX.length());
                this.debug("GuestNode#init(): Configuring ClientCacheFactory with key = " + name + ", value = " + value);
                clientCacheFactory.set(name, value);
            }
            clientCacheFactory.setPoolSubscriptionEnabled(true);
            String locators = this.clustersProperties.getProperty(this.localClusterName);
            for (String locator : locatorsArray = locators.split(",")) {
                String locatorHost = locator.substring(0, locator.indexOf("["));
                String locatorPortString = locator.substring(locator.indexOf("[") + 1, locator.indexOf("]"));
                int locatorPort = Integer.parseInt(locatorPortString);
                this.debug("GuestNode#init(): Adding locator to pool: locatorHost = " + locatorHost + ", locatorPort = " + locatorPort);
                clientCacheFactory.addPoolLocator(locatorHost, locatorPort);
            }
            this.clientCache = clientCacheFactory.create();
            ClientRegionFactory clientRegionFactory = this.clientCache.createClientRegionFactory(ClientRegionShortcut.PROXY);
            this.region = this.clientCache.getRegion(this.regionName);
            this.debug("GuestNode#init(): Get region with name = " + this.regionName + ": region = " + this.region);
            if (this.region == null) {
                this.region = clientRegionFactory.create(this.regionName);
            }
            this.debug("GuestNode#init(): Create region with name = " + this.regionName + ": region = " + this.region);
        }
        catch (Throwable t) {
            this.debug("GuestNode#init(): Throwable caught with message = " + t.getMessage(), t);
        }
    }

    private void waitForStarted() {
        this.debug("GuestNode#waitForStarted(): Waiting for other clusters started");
        while (true) {
            boolean othersStarted = true;
            for (Object key : this.clustersProperties.keySet()) {
                String clusterName = (String)key;
                Long startedAt = (Long)this.region.get((Object)this.createStartedAtKey(clusterName));
                this.debug("GuestNode#waitForStarted(): Checking startedAt: startedAt = " + startedAt + ", processingStartedAt = " + this.processingStartedAt);
                if (startedAt != null && startedAt >= this.processingStartedAt) continue;
                othersStarted = false;
                break;
            }
            if (othersStarted) break;
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.debug("GuestNode#waitForStarted(): Other clusters started");
    }

    private void waitForSent() {
        this.debug("GuestNode#waitForSent(): Waiting for other clusters sent");
        while (true) {
            String clusterName;
            boolean othersSent = true;
            HashMap<String, Long> clusterNameToReceivedAtMap = new HashMap<String, Long>();
            for (Object key : this.clustersProperties.keySet()) {
                clusterName = (String)key;
                if (this.localClusterName.equals(clusterName)) continue;
                Long sentAt = (Long)this.region.get((Object)this.createSentAtKey(clusterName));
                long receivedAt = System.currentTimeMillis();
                if (sentAt == null || sentAt <= this.processingStartedAt) continue;
                clusterNameToReceivedAtMap.put(clusterName, receivedAt);
            }
            for (Object key : this.clustersProperties.keySet()) {
                clusterName = (String)key;
                if (this.localClusterName.equals(clusterName)) continue;
                Long receivedAt = (Long)clusterNameToReceivedAtMap.get(clusterName);
                if (receivedAt == null) {
                    if (!othersSent) continue;
                    othersSent = false;
                    continue;
                }
                this.region.put((Object)this.createReceivedAtKey(clusterName, this.localClusterName), (Object)receivedAt);
            }
            if (othersSent) break;
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.debug("GuestNode#waitForSent(): Other clusters sent");
    }

    private void waitForConnected() {
        this.debug("GuestNode#waitForConnected(): Waiting for all the clusters connected");
        while (true) {
            boolean connected = true;
            block3: for (Object fromKey : this.clustersProperties.keySet()) {
                String fromClusterName = (String)fromKey;
                for (Object toKey : this.clustersProperties.keySet()) {
                    Long receivedAt;
                    String toClusterName = (String)toKey;
                    if (fromClusterName.equals(toClusterName) || (receivedAt = (Long)this.region.get((Object)this.createReceivedAtKey(fromClusterName, toClusterName))) != null) continue;
                    connected = false;
                    continue block3;
                }
            }
            if (connected) break;
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.debug("GuestNode#waitForConnected(): All the clusters connected");
    }

    public boolean waitFor(long timeout) {
        this.debug("GuestNode#waitFor(long): Waiting for task finish with timeout = " + timeout);
        ProcessingTask connectionCheckTask = new ProcessingTask();
        Utils.execute(connectionCheckTask, timeout);
        boolean connected = connectionCheckTask.isConnected();
        this.debug("GuestNode#waitFor(long): Task finished connected = " + connected);
        return connected;
    }

    public void close() {
        try {
            this.debug("GuestNode#close(): Closing the cache");
            this.clientCache.close();
            this.debug("GuestNode#close(): Cache closed = " + this.clientCache.isClosed());
        }
        catch (Throwable t) {
            this.debug("GuestNode#close(): Throwable caught with message = " + t.getMessage(), t);
        }
    }

    public void printState(boolean connected) {
        if (!this.quiet) {
            StringBuilder sb = new StringBuilder();
            if (connected) {
                sb.append(this.localClusterName).append(" <= ");
                for (String string : this.clustersProperties.keySet()) {
                    if (this.localClusterName.equals(string)) continue;
                    Long sentAt = (Long)this.region.get((Object)this.createSentAtKey(string));
                    Long receivedAt = (Long)this.region.get((Object)this.createReceivedAtKey(string, this.localClusterName));
                    long duration = receivedAt - sentAt;
                    sb.append("[").append(string).append(", ").append(duration).append("ms]");
                }
            } else {
                sb.append("Connection process is not finished for ").append(this.localClusterName);
            }
            System.out.println(sb.toString());
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                Utils.exitWithFailure();
            }
            String cluster = args[0];
            Properties clustersProperties = PropertiesHelper.stringToProperties((String)args[1]);
            long timeout = Long.parseLong(args[2]);
            String regionName = args[3];
            boolean debugEnabled = "true".equals(args[4]);
            boolean quiet = "true".equals(args[5]);
            long processingStartedAt = Long.parseLong(args[6]);
            GuestNode guestNode = new GuestNode(cluster, clustersProperties, regionName, debugEnabled, quiet, processingStartedAt);
            boolean connected = guestNode.waitFor(timeout);
            guestNode.printState(connected);
            guestNode.close();
            if (connected) {
                Utils.exitWithSuccess();
            }
            Utils.exitWithFailure();
        }
        catch (Throwable t) {
            Utils.exitWithFailure();
        }
    }

    private void debug(String message) {
        this.debug(message, null);
    }

    private void debug(String message, Throwable t) {
        if (this.debugEnabled) {
            long currentTime = System.currentTimeMillis();
            long timeSinceProcessingStart = currentTime - this.processingStartedAt;
            System.err.println(timeSinceProcessingStart + " [" + this.localClusterName + "] " + message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private class ProcessingTask
    implements Runnable {
        private boolean connected = false;

        private ProcessingTask() {
        }

        public void run() {
            try {
                GuestNode.this.region.put((Object)GuestNode.this.createStartedAtKey(GuestNode.this.localClusterName), (Object)System.currentTimeMillis());
                GuestNode.this.waitForStarted();
                GuestNode.this.region.put((Object)GuestNode.this.createSentAtKey(GuestNode.this.localClusterName), (Object)System.currentTimeMillis());
                GuestNode.this.waitForSent();
                GuestNode.this.waitForConnected();
                this.connected = true;
            }
            catch (Throwable t) {
                this.connected = false;
            }
        }

        public boolean isConnected() {
            return this.connected;
        }
    }
}

