/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.replication;

import com.googlecode.icegem.cacheutils.replication.GuestNode;
import com.googlecode.icegem.utils.JavaProcessLauncher;
import com.googlecode.icegem.utils.PropertiesHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class ReplicationProcessor {
    private Properties clustersProperties;
    private long timeout;
    private final String regionName;
    private final boolean debugEnabled;
    private final boolean quiet;
    private JavaProcessLauncher javaProcessLauncher = new JavaProcessLauncher(true, true, false);
    private long processingStartedAt = System.currentTimeMillis();

    public ReplicationProcessor(Properties clustersProperties, long timeout, String regionName, boolean debugEnabled, boolean quiet) {
        this.clustersProperties = clustersProperties;
        this.timeout = timeout;
        this.regionName = regionName;
        this.debugEnabled = debugEnabled;
        this.quiet = quiet;
    }

    public int process() throws IOException, InterruptedException {
        this.debug("ReplicationProcessor#process(): Processing start");
        Properties gemfireProperties = PropertiesHelper.filterProperties((Properties)System.getProperties(), (String)"gemfire.");
        String[] vmOptions = PropertiesHelper.propertiesToVMOptions((Properties)gemfireProperties);
        this.debug("ReplicationProcessor#process(): vmOptions = " + Arrays.asList(vmOptions));
        ArrayList<Process> processesList = new ArrayList<Process>();
        for (Object keyObject : this.clustersProperties.keySet()) {
            String cluster = (String)keyObject;
            String clustersPropertiesString = PropertiesHelper.propertiesToString((Properties)this.clustersProperties);
            this.debug("ReplicationProcessor#process(): Starting GuestNode with parameters: cluster = " + cluster + ", clustersPropertiesString = " + clustersPropertiesString + ", timeout = " + this.timeout + ", regionName = " + this.regionName);
            Process process = this.javaProcessLauncher.runWithoutConfirmation(GuestNode.class, vmOptions, new String[]{cluster, clustersPropertiesString, String.valueOf(this.timeout), this.regionName, String.valueOf(this.debugEnabled), String.valueOf(this.quiet), String.valueOf(this.processingStartedAt)});
            this.debug("ReplicationProcessor#process(): Adding GuestNode to processList");
            processesList.add(process);
        }
        this.debug("ReplicationProcessor#process(): Waiting for processes finish");
        int mainExitCode = 0;
        int processNumber = 0;
        for (Process process : processesList) {
            this.debug("ReplicationProcessor#process(): Waiting for process #" + processNumber);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                mainExitCode = 1;
            }
            this.debug("ReplicationProcessor#process(): Process #" + processNumber + " finished with exitCode = " + exitCode);
            ++processNumber;
        }
        this.debug("ReplicationProcessor#process(): Processing finished with mainExitCode = " + mainExitCode);
        return mainExitCode;
    }

    private void debug(String message) {
        if (this.debugEnabled) {
            long currentTime = System.currentTimeMillis();
            long timeSinceProcessingStart = currentTime - this.processingStartedAt;
            System.err.println(timeSinceProcessingStart + " [ReplicationProcessor] " + message);
        }
    }
}

