/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.signallistener;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.googlecode.icegem.cacheutils.Tool;
import com.googlecode.icegem.cacheutils.common.Utils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class WaitforTool
extends Tool {
    private static final int DEFAULT_CHECK_INTERVAL = 1000;
    private static final int DEFAULT_TIMEOUT = 60000;
    private String locators;
    private String regionNameToListen;
    private int timeout;
    private int checkInterval;
    private String keyToListen;

    public static boolean waitSignal(Region regionToListen, Object key, long timeout, long checkInterval) throws InterruptedException {
        if (regionToListen == null) {
            throw new NullPointerException("region is null");
        }
        if (checkInterval > timeout) {
            throw new IllegalArgumentException("check interval (" + checkInterval + ") is longer then timeout(" + timeout + ")");
        }
        long fromTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - fromTime <= timeout) {
            if (regionToListen.containsKeyOnServer(key)) {
                return true;
            }
            TimeUnit.MILLISECONDS.sleep(checkInterval);
        }
        return false;
    }

    protected Options constructGnuOptions() {
        Options options = new Options();
        options.addOption("region", true, "region where key appearance is checking");
        options.addOption("locators", true, "available locators");
        options.addOption("key", true, "key for checking");
        options.addOption("timeout", true, "check duration");
        options.addOption("checkInterval", true, "key's check interval");
        return options;
    }

    protected void parseCommandLineArguments(String[] commandLineArguments) {
        GnuParser cmdParser = new GnuParser();
        Options options = this.constructGnuOptions();
        CommandLine cmd = null;
        try {
            cmd = cmdParser.parse(options, commandLineArguments);
        }
        catch (ParseException e) {
            throw new RuntimeException("error parsing cmd args", e);
        }
        if (!(cmd.hasOption("region") && cmd.hasOption("locators") && cmd.hasOption("key"))) {
            this.printHelp(options);
            Utils.exitWithFailure();
        }
        this.locators = cmd.getOptionValue("locators");
        this.regionNameToListen = cmd.getOptionValue("region");
        this.timeout = 60000;
        if (cmd.hasOption("timeout")) {
            this.timeout = Integer.parseInt(cmd.getOptionValue("timeout"));
        } else {
            System.out.println("using default value for timeout: " + this.timeout);
        }
        this.checkInterval = 1000;
        if (cmd.hasOption("checkInterval")) {
            this.checkInterval = Integer.parseInt(cmd.getOptionValue("checkInterval"));
        } else {
            System.out.println("using default value for check interval " + this.checkInterval);
        }
        this.keyToListen = cmd.getOptionValue("key");
    }

    protected void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("waitfor [options]", options);
    }

    public void execute(String[] args, boolean debugEnabled, boolean quiet) {
        this.parseCommandLineArguments(args);
        ClientCacheFactory clientCacheFactory = new ClientCacheFactory();
        for (String locator : this.locators.split(",")) {
            String host = locator.trim().substring(0, locator.indexOf("["));
            int port = Integer.parseInt(locator.substring(locator.indexOf("[") + 1, locator.indexOf("]")));
            clientCacheFactory.addPoolLocator(host, port);
        }
        ClientCache client = clientCacheFactory.create();
        Region signalRegion = client.createClientRegionFactory(ClientRegionShortcut.PROXY).create(this.regionNameToListen);
        int result = 0;
        try {
            result = WaitforTool.waitSignal(signalRegion, this.keyToListen, this.timeout, this.checkInterval) ? 0 : 1;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("error waiting key", e);
        }
        System.out.println("status is " + result);
        client.close();
        System.exit(result);
    }
}

