/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.cacheutils.updater;

import com.gemstone.gemfire.cache.Region;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Updater {
    private static final Logger log = LoggerFactory.getLogger(Updater.class);
    private CountDownLatch done;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegions(Set<Region<?, ?>> regions) {
        this.done = new CountDownLatch(regions.size());
        ExecutorService executor = Executors.newFixedThreadPool(regions.size());
        for (Region<?, ?> region : regions) {
            executor.execute(new UpdateRunner(region));
        }
        try {
            this.done.await();
        }
        catch (InterruptedException e) {
            log.info("Some error ocurred. Will stop updating." + e.getMessage());
        }
        finally {
            executor.shutdown();
        }
    }

    private class UpdateRunner
    implements Runnable {
        private Region region;

        public UpdateRunner(Region region) {
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                for (Object key : this.region.keySetOnServer()) {
                    Object value = this.region.get(key);
                    this.region.put(key, value);
                }
                log.info("Update of region " + this.region.getName() + " successful");
            }
            catch (Throwable t) {
                log.info("Update of region " + this.region.getName() + " failed");
                log.error("Exception occured in region " + this.region.getName() + "\n" + t.getMessage());
            }
            finally {
                Updater.this.done.countDown();
            }
        }
    }
}

