/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.kevinarpe.papaya.testing.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.google.common.collect.ImmutableList;
import com.googlecode.kevinarpe.papaya.annotation.EmptyContainerAllowed;
import com.googlecode.kevinarpe.papaya.annotation.ReadOnlyContainer;
import com.googlecode.kevinarpe.papaya.argument.ObjectArgs;
import com.googlecode.kevinarpe.papaya.testing.logging.CapturingLogger;
import java.util.List;
import javax.annotation.Nullable;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogbackTest
implements CapturingLogger<ILoggingEvent> {
    @Nullable
    private Appender<ILoggingEvent> nullableMockAppender;

    protected AbstractLogbackTest() {
    }

    protected final void addMockAppender() {
        ch.qos.logback.classic.Logger rootLogger = this._getRootLogger();
        Appender mockAppender = this.nullableMockAppender = (Appender)Mockito.mock(Appender.class);
        rootLogger.addAppender(mockAppender);
    }

    private ch.qos.logback.classic.Logger _getRootLogger() {
        Logger uncastRootLogger = LoggerFactory.getLogger((String)"ROOT");
        ch.qos.logback.classic.Logger x = (ch.qos.logback.classic.Logger)ObjectArgs.checkCast((Object)uncastRootLogger, ch.qos.logback.classic.Logger.class, (String)"LoggerFactory.getLogger(Logger.ROOT_LOGGER_NAME)");
        return x;
    }

    protected final void removeMockAppender() {
        ObjectArgs.checkNotNull(this.nullableMockAppender, (String)"nullableMockAppender");
        ch.qos.logback.classic.Logger rootLogger = this._getRootLogger();
        rootLogger.detachAppender(this.nullableMockAppender);
    }

    @EmptyContainerAllowed
    @ReadOnlyContainer
    public List<ILoggingEvent> getLoggingEventList() {
        ObjectArgs.checkNotNull(this.nullableMockAppender, (String)"nullableMockAppender");
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ILoggingEvent.class);
        try {
            ((Appender)Mockito.verify(this.nullableMockAppender, (VerificationMode)Mockito.atLeastOnce())).doAppend(argumentCaptor.capture());
            List x = argumentCaptor.getAllValues();
            return x;
        }
        catch (Throwable ignore) {
            return ImmutableList.of();
        }
    }
}

