/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.datasource;

import com.googlecode.mycontainer.datasource.ConnectionInterceptor;
import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.interceptors.ProxyInterceptor;
import com.googlecode.mycontainer.kernel.reflect.proxy.ProxyEngine;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionResource
implements XAResource {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionResource.class);
    private final Connection conn;
    private final Connection proxy;
    private String name;

    public ConnectionResource(String name, Connection conn) {
        this.name = name;
        this.conn = conn;
        ProxyEngine engine = new ProxyEngine(Connection.class, (Object)conn);
        engine.addInterceptor((ProxyInterceptor)new ConnectionInterceptor());
        this.proxy = (Connection)engine.create();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Connection getProxy() {
        return this.proxy;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public void forget(Xid xid) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public int getTransactionTimeout() throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public int prepare(Xid xid) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public Xid[] recover(int flag) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public void start(Xid xid, int flags) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        throw new KernelRuntimeException("not supported operation");
    }

    private void close() {
        try {
            this.conn.close();
        }
        catch (Exception e) {
            LOG.error("Error closing", (Throwable)e);
        }
    }
}

