/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.datasource;

import com.googlecode.mycontainer.datasource.ConnectionResource;
import com.googlecode.mycontainer.datasource.ConnectionResourceSynchronization;
import com.googlecode.mycontainer.jta.TxEntry;
import com.googlecode.mycontainer.kernel.KernelRuntimeException;
import com.googlecode.mycontainer.kernel.ShutdownHook;
import com.googlecode.mycontainer.kernel.deploy.DeployException;
import com.googlecode.mycontainer.kernel.deploy.Deployer;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDeployer
extends Deployer
implements ShutdownHook,
DataSource {
    private static final long serialVersionUID = -2510091316151254781L;
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceDeployer.class);
    private String transcationManagerName = "TransactionManager";
    private String driver;
    private String url;
    private String user;
    private String pass;
    private String name;
    private String newConnectionSql;
    private PrintWriter logWriter;
    private int loginTimeout;

    public void setTranscationManagerName(String transcationManagerName) {
        this.transcationManagerName = transcationManagerName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setNewConnectionSql(String newConnectionSql) {
        this.newConnectionSql = newConnectionSql;
    }

    public void deploy() {
        try {
            Context ctx = this.getContext();
            LOG.info("Deploying: " + this.name);
            ctx.bind(this.name, (Object)this);
            this.getKernel().addShutdownHook((ShutdownHook)this);
        }
        catch (NamingException e) {
            throw new DeployException((Throwable)e);
        }
    }

    public void shutdown() {
        try {
            Context ctx = this.getContext();
            LOG.info("Undeploying: " + this.name);
            ctx.unbind(this.name);
        }
        catch (NamingException e) {
            throw new DeployException((Throwable)e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.pass);
    }

    @Override
    public Connection getConnection(String username, String password) {
        Connection ret = null;
        try {
            Context ctx = this.getContext();
            TransactionManager tm = (TransactionManager)ctx.lookup(this.transcationManagerName);
            if (tm.getStatus() == 6) {
                ret = this.createConnection();
                return ret;
            }
            Transaction tx = tm.getTransaction();
            TxEntry entry = new TxEntry(tx, this.name);
            Map<TxEntry, Connection> connections = this.lookupConnections();
            ret = connections.get(entry);
            if (ret != null) {
                return ret;
            }
            ret = this.createConnection();
            ret = this.enlist(ret, tx);
            connections.put(entry, ret);
            ConnectionResourceSynchronization sync = new ConnectionResourceSynchronization(connections, entry);
            tx.registerSynchronization((Synchronization)sync);
            return ret;
        }
        catch (ClassNotFoundException e) {
            this.rollbackAndClose(ret);
            throw new DeployException((Throwable)e);
        }
        catch (SQLException e) {
            this.rollbackAndClose(ret);
            throw new DeployException((Throwable)e);
        }
        catch (NamingException e) {
            this.rollbackAndClose(ret);
            throw new DeployException((Throwable)e);
        }
        catch (SystemException e) {
            this.rollbackAndClose(ret);
            throw new DeployException((Throwable)e);
        }
        catch (RollbackException e) {
            this.rollbackAndClose(ret);
            throw new DeployException((Throwable)e);
        }
        catch (RuntimeException e) {
            this.rollbackAndClose(ret);
            throw e;
        }
    }

    private Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.driver);
        Connection ret = DriverManager.getConnection(this.url, this.user, this.pass);
        ret.setAutoCommit(false);
        this.handleNewConnection(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewConnection(Connection con) throws SQLException {
        if (this.newConnectionSql != null && this.newConnectionSql.trim().length() > 0) {
            Statement st = con.createStatement();
            try {
                st.execute(this.newConnectionSql);
            }
            finally {
                try {
                    st.close();
                }
                catch (SQLException ex) {
                    LOG.error("Error closing st.", (Throwable)ex);
                }
            }
            try {
                con.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("error commiting newConnectionSql", e);
            }
        }
    }

    private Map<TxEntry, Connection> lookupConnections() {
        Context ctx = this.getContext();
        try {
            try {
                Map ret = (Map)ctx.lookup("tl/ds/connections");
                return ret;
            }
            catch (NameNotFoundException e) {
                HashMap<TxEntry, Connection> ret = new HashMap<TxEntry, Connection>();
                ctx.bind("tl/ds/connections", ret);
                return ret;
            }
        }
        catch (NamingException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
    }

    private void rollbackAndClose(Connection ret) {
        if (ret != null) {
            try {
                ret.rollback();
                ret.close();
            }
            catch (Exception e) {
                LOG.error("Error closing", (Throwable)e);
            }
        }
    }

    private Connection enlist(Connection ret, Transaction tx) {
        try {
            ConnectionResource resource = new ConnectionResource(this.name, ret);
            tx.enlistResource((XAResource)resource);
            return resource.getProxy();
        }
        catch (SystemException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new KernelRuntimeException((Throwable)e);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new KernelRuntimeException("unsupported opration");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new KernelRuntimeException("unsupported opration");
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new KernelRuntimeException("unsupported opration");
    }
}

