/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mycontainer.commons.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.googlecode.mycontainer.commons.util.ContentUtil;
import com.googlecode.mycontainer.commons.util.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtil {
    public static Map<String, Object> getAttributes(HttpServletRequest req) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Object value = req.getAttribute(key);
            ret.put(key, value);
        }
        return ret;
    }

    public static String getUserPath(HttpServletRequest request) {
        String servetPath = request.getServletPath();
        return ServletUtil.getUserPath(request, "^" + servetPath);
    }

    public static String getUserPath(HttpServletRequest request, String ignore) {
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        String starts = "";
        if (!contextPath.equals("/")) {
            starts = starts + contextPath;
        }
        String ret = requestURI.substring(starts.length());
        ret = ret.replaceAll(ignore, "");
        return ret;
    }

    public static void checkMethods(HttpServletRequest request, HttpServletResponse resp, String msg, String ... alloweds) {
        for (String allowed : alloweds) {
            if (!allowed.equals(request.getMethod())) continue;
            return;
        }
        ServletUtil.sendUnsupportedMethod(resp, msg, alloweds);
    }

    public static void sendUnsupportedMethod(HttpServletResponse resp, String msg, String ... alloweds) {
        for (String allowed : alloweds) {
            resp.addHeader("Allow", allowed);
        }
        ServletUtil.sendError(resp, 405, msg);
    }

    public static void sendError(HttpServletResponse resp, int code, String msg) {
        try {
            if (msg == null) {
                resp.sendError(code);
            } else {
                resp.sendError(code, msg);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String checkParameter(HttpServletRequest req, HttpServletResponse resp, String name, String ... requires) {
        String value = req.getParameter(name);
        if (value == null) {
            value = "";
        }
        value = value.trim();
        for (String require : requires) {
            if (!require.equals(value)) continue;
            return require.length() == 0 ? requires[0] : require;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("parameter required '").append(name).append("'");
        if (requires.length > 0) {
            sb.append(" with one of these: ").append(Arrays.toString(requires));
        } else {
            sb.append(" with any value");
        }
        sb.append(", but was: '").append(value).append("'");
        throw new RuntimeException(sb.toString());
    }

    public static <T> List<T> getParameters(HttpServletRequest req, String name, Class<T> clazz) {
        try {
            String[] values = req.getParameterValues(name);
            if (values == null) {
                return new ArrayList();
            }
            ArrayList<T> ret = new ArrayList<T>(values.length);
            for (String value : values) {
                Constructor<T> cons = clazz.getConstructor(String.class);
                T parsed = cons.newInstance(value);
                ret.add(parsed);
            }
            return ret;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, List<String>> getHeaders(Map<String, List<String>> ret, HttpServletRequest request) {
        if (ret == null) {
            ret = new HashMap<String, List<String>>();
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration headers = request.getHeaders(name);
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                List<String> list = ret.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    ret.put(name, list);
                }
                list.add(header);
            }
        }
        return null;
    }

    public static Map<String, List<String>> getParameters(Map<String, List<String>> ret, HttpServletRequest request) {
        if (ret == null) {
            ret = new HashMap<String, List<String>>();
        }
        Set entries = request.getParameterMap().entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            List<String> list = ret.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                ret.put(key, list);
            }
            list.addAll(Arrays.asList(values));
        }
        return ret;
    }

    public static void setHeaders(HttpServletResponse response, Map<String, List<String>> headers) {
        Set<Map.Entry<String, List<String>>> set = headers.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                if (value == null) continue;
                response.addHeader(key, value);
            }
        }
    }

    public static void write(HttpServletResponse response, char[] array) {
        try {
            response.getWriter().write(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(HttpServletResponse response, byte[] content) {
        try {
            response.getOutputStream().write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement readJson(HttpServletRequest req) {
        try {
            ServletUtil.checkContentType(req);
            BufferedReader reader = req.getReader();
            JsonElement json = JsonUtil.parse((Reader)reader);
            return json;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkContentType(HttpServletRequest req) {
        String contentType = ContentUtil.getMediaType((String)req.getContentType());
        if (contentType != null && !contentType.equals("application/json")) {
            throw new RuntimeException("Content-Type must be application/json");
        }
        String charset = req.getCharacterEncoding();
        if (charset == null) {
            throw new RuntimeException("charset is required in Content-Type");
        }
    }

    public static void write(HttpServletResponse resp, JsonElement obj) {
        try {
            JsonObject json;
            JsonElement lastModified;
            if (obj instanceof JsonObject && JsonUtil.t((Object)(lastModified = (json = (JsonObject)obj).get("_lastModified")))) {
                resp.setDateHeader("Last-Modified", lastModified.getAsLong());
            }
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().write(obj == null ? "null" : obj.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement paramJson(HttpServletRequest req, String name) {
        String value = ServletUtil.param(req, name);
        return value == null ? null : JsonUtil.parse((String)value);
    }

    public static String param(HttpServletRequest req, String name) {
        String ret = req.getParameter(name);
        if (ret != null) {
            ret = ret.trim();
        }
        return ret == null || ret.length() == 0 ? null : ret;
    }

    public static JsonArray paramJsons(HttpServletRequest req, String name) {
        String[] values = req.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        JsonArray ret = new JsonArray();
        for (String str : values) {
            ret.add(JsonUtil.parse((String)str));
        }
        return ret;
    }

    public static void writeJson(HttpServletResponse resp, Object value) {
        ServletUtil.write(resp, JsonUtil.createBasic((Object)value));
    }

    public static String getCookie(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

