/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.demo.performance;

import com.googlecode.openbox.demo.performance.PerformanceData;
import com.googlecode.openbox.demo.performance.PerformanceDataGroup;
import com.googlecode.openbox.demo.performance.RequestParamFactory;
import com.googlecode.openbox.demo.performance.RequestSender;
import com.googlecode.openbox.demo.performance.requests.DemoProxyRequestParam;
import com.googlecode.openbox.http.TimeLine;
import com.googlecode.openbox.http.monitors.CyclicBarrierMonitor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRequestSender
implements RequestSender {
    private static final Logger logger = LogManager.getLogger();
    private int threadCount;
    private String url;
    private String dcName;
    private CyclicBarrierMonitor cyclicBarrierMonitor;
    private PerformanceDataGroup group;
    private CloseableHttpClient httpClient;

    public AbstractRequestSender(CloseableHttpClient httpClient, int threadCount, String url, String dcName) {
        this.httpClient = httpClient;
        this.threadCount = threadCount;
        this.url = url;
        this.dcName = dcName;
        this.cyclicBarrierMonitor = CyclicBarrierMonitor.create((int)threadCount);
        this.group = PerformanceDataGroup.create("proxy test ", threadCount);
    }

    public abstract ClientServerDuration sendRequest(DemoProxyRequestParam var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        ExecutorService es = Executors.newFixedThreadPool(this.threadCount);
        try {
            Future[] results = new Future[this.threadCount];
            for (int i = 0; i < this.threadCount; ++i) {
                results[i] = es.submit(new Task());
            }
            for (int j = 0; j < this.threadCount; ++j) {
                try {
                    PerformanceData pd = (PerformanceData)results[j].get();
                    this.group.addPerformanceData(pd);
                    continue;
                }
                catch (Exception e) {
                    logger.error("error for Future get result ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            this.group.setGroupTimeLine(this.getCyclicBarrierMonitor().getTimeLine());
        }
        finally {
            es.shutdown();
            try {
                es.awaitTermination(30L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                logger.error("error for awaitTermination", (Throwable)e);
            }
        }
    }

    @Override
    public PerformanceDataGroup getPerformanceDataGroup() {
        return this.group;
    }

    private String generateId() {
        return "request[" + this.threadCount + "-T-" + Thread.currentThread().getId() + "]";
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDcName() {
        return this.dcName;
    }

    public CyclicBarrierMonitor getCyclicBarrierMonitor() {
        return this.cyclicBarrierMonitor;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final class Task
    implements Callable<PerformanceData> {
        private DemoProxyRequestParam param = RequestParamFactory.createDemoProxyRequestParam(500);

        @Override
        public PerformanceData call() throws Exception {
            try {
                this.param.setId(AbstractRequestSender.this.generateId());
                ClientServerDuration csDuration = AbstractRequestSender.this.sendRequest(this.param);
                PerformanceData pd = new PerformanceData();
                pd.setId(this.param.getId());
                pd.setClientTimeLine(csDuration.getClientTimeLine());
                pd.setServerDuration(csDuration.getServerDuration());
                return pd;
            }
            catch (Exception e) {
                logger.error("execute thread error !!", (Throwable)e);
                throw e;
            }
        }
    }

    public final class ClientServerDuration {
        private TimeLine clientTimeLine;
        private long serverDuration;

        public ClientServerDuration(TimeLine clientTimeLine, long serverDuration) {
            this.clientTimeLine = clientTimeLine;
            this.serverDuration = serverDuration;
        }

        public TimeLine getClientTimeLine() {
            return this.clientTimeLine;
        }

        public long getServerDuration() {
            return this.serverDuration;
        }
    }
}

