/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.demo.performance;

import com.googlecode.openbox.common.UtilsAPI;
import com.googlecode.openbox.demo.performance.PerformanceData;
import com.googlecode.openbox.http.GsonFactory;
import com.googlecode.openbox.http.TimeLine;

public class PerformanceDataGroup {
    private String name;
    private int totalCount;
    private TimeLine groupTimeLine;
    private PerformanceData[] performanceDatas;
    private int index;
    public static final int OVERALL_WIDTH = 123;

    private PerformanceDataGroup(String name, int totalCount) {
        this.name = name;
        this.totalCount = totalCount;
        this.performanceDatas = new PerformanceData[totalCount];
        this.index = 0;
    }

    public static PerformanceDataGroup create(String name, int totalCount) {
        return new PerformanceDataGroup(name, totalCount);
    }

    public synchronized void addPerformanceData(PerformanceData pd) {
        this.performanceDatas[this.index++] = pd;
    }

    public TimeLine getGroupTimeLine() {
        return this.groupTimeLine;
    }

    public void setGroupTimeLine(TimeLine groupTimeLine) {
        this.groupTimeLine = groupTimeLine;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getIndex() {
        return this.index;
    }

    public long getClientAverageDuration() {
        long totalDuration = 0L;
        for (int i = 0; i < this.performanceDatas.length; ++i) {
            PerformanceData performanceData = this.performanceDatas[i];
            totalDuration += performanceData.getClientTimeLine().getDuration();
        }
        return totalDuration / (long)this.performanceDatas.length;
    }

    public long getServerAverageDuration() {
        long totalDuration = 0L;
        for (int i = 0; i < this.performanceDatas.length; ++i) {
            PerformanceData performanceData = this.performanceDatas[i];
            totalDuration += performanceData.getServerDuration();
        }
        return totalDuration / (long)this.performanceDatas.length;
    }

    public String getPerformanceInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("|").append(UtilsAPI.getFixedColumn((int)123, (String)"-", (String)this.name)).append("\n");
        String overInfo = "totalCount=[" + this.totalCount + "], totalDuration=[" + this.groupTimeLine.getDuration() + "]ms, serverAverageDuration=[" + this.getServerAverageDuration() + "]ms/request, clientAverageDuration=[" + this.getClientAverageDuration() + "]ms/request";
        sb.append("|").append(UtilsAPI.getFixedColumn((int)123, (String)" ", (String)overInfo));
        sb.append("\n");
        sb.append("|").append(UtilsAPI.getFixedColumn((int)123, (String)"-", (String)""));
        sb.append("\n");
        for (int i = 0; i < this.performanceDatas.length; ++i) {
            PerformanceData pd = this.performanceDatas[i];
            if (i == 0) {
                sb.append(pd.getHeaderExpress());
                sb.append("\n");
            }
            sb.append(pd);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public PerformanceData[] getPerformanceDatas() {
        return this.performanceDatas;
    }

    public String toString() {
        return GsonFactory.createGson().toJson((Object)this);
    }
}

