/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.demo.performance.report;

import com.googlecode.openbox.common.IOUtils;
import com.googlecode.openbox.demo.performance.PerformanceReport;
import java.io.File;

public abstract class AbstractPerformanceReport
implements PerformanceReport {
    public static final String DEFAULT_REPORT_LOCATION = new File(".").getAbsolutePath();
    public static final String PD_REPORTNAME = "/PerformanceData.";
    private String title;
    private String location;

    public AbstractPerformanceReport(String title, String location) {
        this.title = title;
        this.location = location;
    }

    public abstract String getReportFileExtention();

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public File getReportFile() {
        String location = this.getLocation();
        if (null == location) {
            location = DEFAULT_REPORT_LOCATION;
        }
        String fileName = PD_REPORTNAME + this.getReportFileExtention();
        File file = new File(location + fileName);
        IOUtils.autoCreateParentDirectory((File)file);
        return file;
    }
}

