/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.demo.performance.report;

import com.googlecode.openbox.demo.performance.PerformanceDataGroup;
import com.googlecode.openbox.demo.performance.report.AbstractPerformanceReport;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class JFreeChartPerformanceReport
extends AbstractPerformanceReport {
    public static final float IMAGE_QUALITY = 1.0f;
    public static final int IMAGE_WIDTH = 900;
    public static final int IMAGE_HEIGHT = 700;

    public static JFreeChartPerformanceReport create(String title, String location) {
        return new JFreeChartPerformanceReport(title, location);
    }

    public JFreeChartPerformanceReport(String title, String location) {
        super(title, location);
    }

    @Override
    public void report(PerformanceDataGroup[] performanceDataGroups) {
        JFreeChart chart = JFreeChartPerformanceReport.createChart(this.getTitle(), performanceDataGroups);
        try {
            ChartUtilities.saveChartAsJPEG((File)this.getReportFile(), (float)1.0f, (JFreeChart)chart, (int)900, (int)700);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ApplicationFrame reportFrame = new ApplicationFrame(this.getTitle());
            ChartPanel chartpanel = new ChartPanel(chart, true, true, true, false, true);
            chartpanel.setPreferredSize(new Dimension(900, 700));
            reportFrame.setContentPane((Container)chartpanel);
            reportFrame.pack();
            RefineryUtilities.centerFrameOnScreen((Window)reportFrame);
            reportFrame.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getReportFileExtention() {
        return "jpg";
    }

    private static JFreeChart createChart(String title, PerformanceDataGroup[] performanceDataGroups) {
        XYDataset xydataset = JFreeChartPerformanceReport.createSystemThroughputDataset(performanceDataGroups);
        NumberAxis numberaxisX = new NumberAxis("ThreadCount");
        numberaxisX.setAutoRangeIncludesZero(true);
        NumberAxis numberaxisY = new NumberAxis("Duration (ms)");
        numberaxisY.setAutoRangeIncludesZero(true);
        DecimalFormat decimalformat = new DecimalFormat("0");
        numberaxisX.setNumberFormatOverride((NumberFormat)decimalformat);
        numberaxisY.setNumberFormatOverride((NumberFormat)decimalformat);
        XYSplineRenderer xysplinerenderer = new XYSplineRenderer();
        XYPlot xyplot = new XYPlot(xydataset, (ValueAxis)numberaxisX, (ValueAxis)numberaxisY, (XYItemRenderer)xysplinerenderer);
        xyplot.setBackgroundPaint((Paint)Color.lightGray);
        xyplot.setDomainGridlinePaint((Paint)Color.white);
        xyplot.setRangeGridlinePaint((Paint)Color.white);
        xyplot.setRangePannable(false);
        JFreeChart jfreechart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)xyplot, true);
        jfreechart.setBackgroundPaint((Paint)Color.white);
        return jfreechart;
    }

    private static XYDataset createSystemThroughputDataset(PerformanceDataGroup[] performanceDataGroups) {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        XYSeries systemThroughoutSeries = new XYSeries((Comparable)((Object)"System Throughput"));
        XYSeries serverAverageSeries = new XYSeries((Comparable)((Object)"Server Average Duration"));
        XYSeries clientAverageSeries = new XYSeries((Comparable)((Object)"Client Average Duration"));
        int progressX = 0;
        for (PerformanceDataGroup performanceDataGroup : performanceDataGroups) {
            int groupCount = performanceDataGroup.getTotalCount();
            long groupDuration = performanceDataGroup.getGroupTimeLine().getDuration();
            progressX = groupCount;
            systemThroughoutSeries.add((double)progressX, (double)groupDuration);
            serverAverageSeries.add((double)progressX, (double)performanceDataGroup.getServerAverageDuration());
            clientAverageSeries.add((double)progressX, (double)performanceDataGroup.getClientAverageDuration());
        }
        xyseriescollection.addSeries(systemThroughoutSeries);
        xyseriescollection.addSeries(serverAverageSeries);
        xyseriescollection.addSeries(clientAverageSeries);
        return xyseriescollection;
    }
}

