/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http;

import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.RequestBuilder;
import com.googlecode.openbox.http.RequestConverter;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRequestBuilder
implements RequestBuilder {
    private static final Logger logger = LogManager.getLogger();
    public static final String CHARSET_UTF_8 = Consts.UTF_8.name();
    private URIBuilder builder;
    private List<NameValuePair> headers = null;

    public AbstractRequestBuilder(URIBuilder builder) {
        this.builder = builder;
    }

    public AbstractRequestBuilder(String url) {
        try {
            this.builder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            String msg = "your url: [" + url + "] is invalid format ,Please check it";
            logger.error(msg, (Throwable)e);
            throw new HttpClientException(msg, e);
        }
    }

    public AbstractRequestBuilder(String url, String path) {
        try {
            this.builder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            String msg = "your url: [" + url + "] is invalid format ,Please check it";
            logger.error(msg, (Throwable)e);
            throw new HttpClientException(msg, e);
        }
        this.builder.setPath(path);
    }

    public AbstractRequestBuilder(String scheme, String host, String path) {
        this.builder = new URIBuilder();
        this.builder.setScheme(scheme);
        this.builder.setHost(host);
        this.builder.setPath(path);
    }

    public AbstractRequestBuilder(String scheme, String host, int port, String path) {
        this.builder = new URIBuilder();
        this.builder.setScheme(scheme);
        this.builder.setHost(host);
        this.builder.setPort(port);
        this.builder.setPath(path);
    }

    @Override
    public URIBuilder getURIBuilder() {
        return this.builder;
    }

    @Override
    public RequestConfig getRequestConfig() {
        return null;
    }

    @Override
    public List<NameValuePair> getHeaders() {
        return this.headers;
    }

    @Override
    public HttpRequestBase toRequest() {
        return RequestConverter.toHttpRequestBase(this);
    }

    public void addHeader(String name, String value) {
        if (null == this.headers) {
            this.headers = new LinkedList<NameValuePair>();
        }
        this.add(this.headers, name, value);
    }

    public void setHeader(String name, String value) {
        if (null == this.headers) {
            this.headers = new LinkedList<NameValuePair>();
        }
        this.set(this.headers, name, value);
    }

    public void removeHeader(String name) {
        this.remove(this.headers, name);
    }

    protected void add(List<NameValuePair> list, String name, String value) {
        list.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    protected void set(List<NameValuePair> list, String name, String value) {
        boolean isFind = false;
        for (int index = 0; index < list.size(); ++index) {
            NameValuePair header = list.get(index);
            if (!header.getName().equals(name)) continue;
            list.set(index, (NameValuePair)new BasicNameValuePair(name, value));
            isFind = true;
            break;
        }
        if (!isFind) {
            list.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    protected void remove(List<NameValuePair> list, String name) {
        if (null == list) {
            return;
        }
        for (int index = 0; index < list.size(); ++index) {
            NameValuePair header = list.get(index);
            if (!header.getName().equals(name)) continue;
            list.remove(index);
            break;
        }
    }
}

