/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http;

import com.googlecode.openbox.http.ExecutorMonitorManager;
import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.Response;
import com.googlecode.openbox.http.TimeLine;
import com.googlecode.openbox.http.monitors.TimeLineMonitor;
import com.googlecode.openbox.http.responses.ResponseUtils;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractResponse
implements Response {
    private static final Logger logger = LogManager.getLogger();
    private HttpResponse httpResponse;
    private String content;
    private HttpContext httpContext;
    private ExecutorMonitorManager executorMonitorManager;

    public AbstractResponse(HttpResponse httpResponse, HttpContext httpContext, ExecutorMonitorManager executorMonitorManager) {
        this.httpResponse = httpResponse;
        this.httpContext = httpContext;
        this.executorMonitorManager = executorMonitorManager;
        this.content = ResponseUtils.getStringContent(this.getHttpResponse());
        EntityUtils.consumeQuietly((HttpEntity)this.getHttpResponse().getEntity());
        if (logger.isInfoEnabled()) {
            logger.info(this.getResponseLog());
        }
    }

    @Override
    public TimeLine getTimeLine() {
        TimeLineMonitor timeLineMonitor = (TimeLineMonitor)this.executorMonitorManager.getMonitor("monitor.TimeRecorder");
        if (null == timeLineMonitor) {
            throw HttpClientException.create("TimeLineMonitor monitor should be default required monitor , but we can't get it , please check code !");
        }
        return timeLineMonitor.toTimeLine();
    }

    @Override
    public int getStatusCode() {
        return ResponseUtils.getStatusCode(this.httpResponse);
    }

    @Override
    public Header[] getHeaders() {
        return ResponseUtils.getAllHeaders(this.httpResponse);
    }

    private HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public static ContentType getUtf8ContentType(ContentType contentType) {
        return ContentType.create((String)contentType.getMimeType(), (Charset)Consts.UTF_8);
    }

    private String getResponseLog() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n=======================================[T-" + Thread.currentThread().getId() + " Response ]============================================\n");
            sb.append("status code -->[").append(this.getStatusCode() + "]");
            sb.append("\n------------------------ response headers --------------------------\n");
            Header[] responseHeaders = this.getHeaders();
            if (null != responseHeaders) {
                for (Header header : responseHeaders) {
                    sb.append(header.getName()).append(":").append(header.getValue()).append("\n");
                }
            }
            sb.append("\n------------------------ response content --------------------------\n");
            if (null != this.getContent()) {
                sb.append(this.getContent());
            }
            sb.append("\n=================================================================================================\n");
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public abstract ContentType[] getSupportedContentTypes();
}

