/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http;

import com.googlecode.openbox.http.AbstractResponseHandler;
import com.googlecode.openbox.http.ExecutorMonitorManager;
import com.googlecode.openbox.http.ExecutorMonitorManagerImpl;
import com.googlecode.openbox.http.HttpExecutor;
import com.googlecode.openbox.http.Request;
import com.googlecode.openbox.http.RequestConverter;
import com.googlecode.openbox.http.RequestProxy;
import com.googlecode.openbox.http.Response;
import com.googlecode.openbox.http.monitors.TimeLineMonitor;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultHttpExecutor<T extends Response>
implements HttpExecutor<T> {
    private static final Logger logger = LogManager.getLogger();
    private AbstractResponseHandler<? extends T> responseHandler;
    private CloseableHttpClient httpClient;
    private Request request;
    private T response;
    private HttpContext context;
    private ExecutorMonitorManager executorMonitorManager;

    public DefaultHttpExecutor(CloseableHttpClient httpClient, Request request, AbstractResponseHandler<? extends T> responseHandler) {
        this.httpClient = httpClient;
        this.request = request;
        this.responseHandler = responseHandler;
        this.context = new BasicHttpContext();
        this.responseHandler.setHttpContext(this.context);
        this.executorMonitorManager = ExecutorMonitorManagerImpl.newInstance();
        this.responseHandler.setExecutorMonitorManager(this.executorMonitorManager);
    }

    @Override
    public void registerHttpRequestProxy(RequestProxy requestProxy) {
        requestProxy.executeProxy(this.request);
    }

    @Override
    public ExecutorMonitorManager getExecutorMonitorManager() {
        return this.executorMonitorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws ClientProtocolException, IOException {
        HttpRequestBase httpRequest = this.request.toRequest();
        if (logger.isInfoEnabled()) {
            logger.info(RequestConverter.getHttpRequestLog(httpRequest, this.request.getEntity()));
        }
        this.registerDefaultMonitors();
        this.executorMonitorManager.startMonitors();
        try {
            this.response = (Response)this.httpClient.execute((HttpUriRequest)httpRequest, this.responseHandler, this.context);
        }
        finally {
            this.executorMonitorManager.endMonitors();
        }
        this.response.getTimeLine().printLog();
        return this.response.getStatusCode();
    }

    private void registerDefaultMonitors() {
        this.executorMonitorManager.register(TimeLineMonitor.create());
    }

    @Override
    public T getResponse() {
        return this.response;
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(HttpContext context) {
        this.context = context;
    }
}

