/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http;

import com.googlecode.openbox.http.ExecutorMonitor;
import com.googlecode.openbox.http.ExecutorMonitorManager;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutorMonitorManagerImpl
implements ExecutorMonitorManager {
    private static final Logger logger = LogManager.getLogger();
    private List<ExecutorMonitor> monitors = new LinkedList<ExecutorMonitor>();

    private ExecutorMonitorManagerImpl() {
    }

    public static ExecutorMonitorManagerImpl newInstance() {
        return new ExecutorMonitorManagerImpl();
    }

    @Override
    public void register(ExecutorMonitor monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public void unregister(ExecutorMonitor monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public void register(List<ExecutorMonitor> subMonitors) {
        this.monitors.addAll(subMonitors);
    }

    @Override
    public void unregister(List<ExecutorMonitor> subMonitors) {
        this.monitors.removeAll(subMonitors);
    }

    @Override
    public List<ExecutorMonitor> list() {
        return this.monitors;
    }

    @Override
    public ExecutorMonitor getMonitor(String name) {
        for (ExecutorMonitor monitor : this.monitors) {
            if (!monitor.getName().equals(name)) continue;
            return monitor;
        }
        return null;
    }

    @Override
    public void unregisterAll() {
        this.monitors.clear();
    }

    @Override
    public void startMonitors() {
        List<ExecutorMonitor> monitors = this.list();
        for (int index = 0; index < monitors.size(); ++index) {
            ExecutorMonitor monitor = monitors.get(index);
            monitor.start();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\n monitor[" + index + "]-->" + monitor.getName() + " started ~~~~~~");
        }
    }

    @Override
    public void endMonitors() {
        List<ExecutorMonitor> monitors = this.list();
        int num = monitors.size();
        for (int index = num - 1; index >= 0; --index) {
            ExecutorMonitor monitor = monitors.get(index);
            monitor.end();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\n monitor[" + index + "]-->" + monitor.getName() + " ended ~~~~~~");
        }
    }
}

