/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http;

import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.HttpRequestFactory;
import com.googlecode.openbox.http.RequestBuilder;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RequestConverter {
    private static final Logger logger = LogManager.getLogger();

    private RequestConverter() {
    }

    public static HttpRequestBase toHttpRequestBase(RequestBuilder request) {
        HttpRequestBase httpRequestBase = null;
        httpRequestBase = null == request.getEntity() ? RequestConverter.getNoBodyRequestBase(request) : RequestConverter.getHasBodyRequest(request);
        return RequestConverter.internBuild(httpRequestBase, request);
    }

    public static String getHttpRequestLog(HttpRequestBase request, HttpEntity requestEntity) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n===================================== [T-" + Thread.currentThread().getId() + " Request ]===============================================\n");
            sb.append(request.getMethod()).append("\n").append(request.getURI().toString()).append("\n");
            sb.append("------------------------headers--------------------------\n");
            Header[] headers = request.getAllHeaders();
            if (null != headers) {
                for (Header header : headers) {
                    sb.append(header.getName()).append(":").append(header.getValue()).append("\n");
                }
            }
            sb.append("------------------------ body --------------------------\n");
            if (null != requestEntity) {
                sb.append(EntityUtils.toString((HttpEntity)requestEntity, (String)"UTF-8"));
            }
            sb.append("\n===================================================================================================\n");
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private static HttpRequestBase getHasBodyRequest(RequestBuilder request) {
        return HttpRequestFactory.createHasBodyRequest(request.getMethod());
    }

    private static HttpRequestBase getNoBodyRequestBase(RequestBuilder request) {
        return HttpRequestFactory.createNoBodyRequestBase(request.getMethod());
    }

    private static HttpRequestBase internBuild(HttpRequestBase httpRequestBase, RequestBuilder request) {
        RequestConfig config;
        RequestConverter.buildURI(httpRequestBase, request);
        RequestConverter.buildHeaders(httpRequestBase, request);
        if (httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
            RequestConverter.buildEntity((HttpEntityEnclosingRequestBase)httpRequestBase, request);
        }
        if (null != (config = request.getRequestConfig())) {
            httpRequestBase.setConfig(config);
        }
        return httpRequestBase;
    }

    private static void buildURI(HttpRequestBase httpRequestBase, RequestBuilder request) {
        try {
            httpRequestBase.setURI(request.getURIBuilder().build());
        }
        catch (URISyntaxException e) {
            String msg = "request URIBuilder do build error !";
            logger.error(msg, (Throwable)e);
            throw new HttpClientException(msg, e);
        }
    }

    private static void buildHeaders(HttpRequestBase httpRequestBase, RequestBuilder request) {
        List<NameValuePair> headers = request.getHeaders();
        if (null != headers) {
            for (NameValuePair header : headers) {
                httpRequestBase.setHeader(header.getName(), header.getValue());
            }
        }
    }

    private static void buildEntity(HttpEntityEnclosingRequestBase httpRequestBase, RequestBuilder request) {
        httpRequestBase.setEntity(request.getEntity());
    }
}

