/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.extention;

import com.googlecode.openbox.http.ExecutorMonitor;
import com.googlecode.openbox.http.HttpExecutor;
import com.googlecode.openbox.http.RequestProxy;
import com.googlecode.openbox.http.extention.AppClientExtendable;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class ExtendedAppClient
implements AppClientExtendable {
    private CloseableHttpClient httpClient;
    private List<RequestProxy> mcProxys;
    private List<ExecutorMonitor> monitors;

    public ExtendedAppClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        this.mcProxys = new LinkedList<RequestProxy>();
        this.monitors = new LinkedList<ExecutorMonitor>();
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void registerProxy(RequestProxy proxy) {
        this.mcProxys.add(proxy);
    }

    @Override
    public void unregisterProxy(RequestProxy proxy) {
        this.mcProxys.remove(proxy);
    }

    @Override
    public void registerMonitor(ExecutorMonitor monitor) {
        this.monitors.add(monitor);
    }

    @Override
    public void unregisterMonitor(ExecutorMonitor monitor) {
        this.monitors.remove(monitor);
    }

    @Override
    public void cleanAllProxy() {
        this.mcProxys.clear();
    }

    @Override
    public void cleanAllMonitor() {
        this.monitors.clear();
    }

    public void registerAllPlugins(HttpExecutor<?> httpExecutor) {
        for (RequestProxy mcProxy : this.mcProxys) {
            httpExecutor.registerHttpRequestProxy(mcProxy);
        }
        httpExecutor.getExecutorMonitorManager().register(this.monitors);
    }
}

