/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.httpbuilder;

import com.googlecode.openbox.common.XmlUtils;
import com.googlecode.openbox.http.ExecutorMonitorManager;
import com.googlecode.openbox.http.ExecutorMonitorManagerImpl;
import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.HttpRequestFactory;
import com.googlecode.openbox.http.RequestConverter;
import com.googlecode.openbox.http.TimeLine;
import com.googlecode.openbox.http.monitors.TimeLineMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;

public class HttpBuilder {
    private static final Logger logger = LogManager.getLogger();
    public static final CloseableHttpClient DEFAULT_HTTPCLIENT = HttpClients.custom().setMaxConnTotal(1000).setMaxConnPerRoute(1000).build();
    private String method;
    private URI uri = null;
    private List<NameValuePair> parameters;
    private List<NameValuePair> headers;
    private List<NameValuePair> forms;
    private HttpEntity requestEntity = null;
    private URIBuilder uriBuilder = new URIBuilder();
    private EntityBuilder entityBuilder = EntityBuilder.create();
    private RequestConfig requestConfig;
    private boolean hasForm = false;
    private boolean hasOtherBody = false;
    private Response response;
    private ExecutorMonitorManager executorMonitorManager = ExecutorMonitorManagerImpl.newInstance();
    private CloseableHttpClient customHttpClient;

    private HttpBuilder() {
    }

    private HttpBuilder(CloseableHttpClient customHttpClient) {
        this();
        this.customHttpClient = customHttpClient;
    }

    public static HttpBuilder create() {
        return new HttpBuilder();
    }

    public static HttpBuilder create(CloseableHttpClient customHttpClient) {
        return new HttpBuilder(customHttpClient);
    }

    public HttpBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpBuilder setUrl(String url) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw HttpClientException.create("build your url [" + url + "] error !", e);
        }
        this.uriBuilder.setScheme(uri.getScheme());
        this.uriBuilder.setHost(uri.getHost());
        this.uriBuilder.setPort(uri.getPort());
        this.uriBuilder.setUserInfo(uri.getUserInfo());
        this.uriBuilder.setPath(uri.getPath());
        this.parameters = this.parseQuery(uri.getRawQuery(), Consts.UTF_8);
        this.uriBuilder.setFragment(uri.getFragment());
        return this;
    }

    private List<NameValuePair> parseQuery(String query, Charset charset) {
        if (query != null && query.length() > 0) {
            return URLEncodedUtils.parse((String)query, (Charset)charset);
        }
        return null;
    }

    public HttpBuilder setScheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public HttpBuilder setUserInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public HttpBuilder setUserInfo(String username, String password) {
        return this.setUserInfo(username + ':' + password);
    }

    public HttpBuilder setHost(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public HttpBuilder setPort(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public HttpBuilder setPath(String path) {
        this.uriBuilder.setPath(path);
        return this;
    }

    public HttpBuilder setFragment(String fragment) {
        this.uriBuilder.setFragment(fragment);
        return this;
    }

    public HttpBuilder addParameter(String name, String value) {
        if (null == this.parameters) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.add(this.parameters, name, value);
        return this;
    }

    public HttpBuilder setParameter(String name, String value) {
        if (null == this.parameters) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.set(this.parameters, name, value);
        return this;
    }

    public HttpBuilder removeParameter(String name) {
        this.remove(this.parameters, name);
        return this;
    }

    public HttpBuilder addHeader(String name, String value) {
        if (null == this.headers) {
            this.headers = new LinkedList<NameValuePair>();
        }
        this.add(this.headers, name, value);
        return this;
    }

    public HttpBuilder setHeader(String name, String value) {
        if (null == this.headers) {
            this.headers = new LinkedList<NameValuePair>();
        }
        this.set(this.headers, name, value);
        return this;
    }

    public HttpBuilder removeHeader(String name) {
        this.remove(this.headers, name);
        return this;
    }

    public HttpBuilder addForm(String name, String value) {
        if (null == this.forms) {
            this.forms = new LinkedList<NameValuePair>();
        }
        this.add(this.forms, name, value);
        this.hasForm = true;
        return this;
    }

    public HttpBuilder setForm(String name, String value) {
        if (null == this.forms) {
            this.forms = new LinkedList<NameValuePair>();
        }
        this.set(this.forms, name, value);
        this.hasForm = true;
        return this;
    }

    public HttpBuilder removeForm(String name) {
        this.remove(this.forms, name);
        if (null == this.forms || this.forms.size() <= 0) {
            this.hasForm = false;
        }
        return this;
    }

    public HttpBuilder setText(String text) {
        this.entityBuilder.setText(text);
        this.hasOtherBody = true;
        return this;
    }

    public HttpBuilder setBinary(byte[] binary) {
        this.entityBuilder.setBinary(binary);
        this.hasOtherBody = true;
        return this;
    }

    public HttpBuilder setStream(InputStream stream) {
        this.entityBuilder.setStream(stream);
        this.hasOtherBody = true;
        return this;
    }

    public HttpBuilder setSerializable(Serializable serializable) {
        this.entityBuilder.setSerializable(serializable);
        this.hasOtherBody = true;
        return this;
    }

    public HttpBuilder setFile(File file) {
        this.entityBuilder.setFile(file);
        this.hasOtherBody = true;
        return this;
    }

    public HttpBuilder setContentType(ContentType contentType) {
        this.entityBuilder.setContentType(contentType);
        return this;
    }

    public HttpBuilder setContentEncoding(String contentEncoding) {
        this.entityBuilder.setContentEncoding(contentEncoding);
        return this;
    }

    public HttpBuilder chunked() {
        this.entityBuilder.chunked();
        return this;
    }

    public HttpBuilder gzipCompress() {
        this.entityBuilder.gzipCompress();
        return this;
    }

    public HttpRequestBase build() {
        if (null != this.parameters && this.parameters.size() > 0) {
            this.uriBuilder.addParameters(this.parameters);
        }
        if (this.hasForm) {
            this.entityBuilder.setParameters(this.forms);
        }
        Object httpRequest = null;
        httpRequest = this.hasBody() ? HttpRequestFactory.createHasBodyRequest(this.method) : HttpRequestFactory.createNoBodyRequestBase(this.method);
        try {
            this.uri = this.uriBuilder.build();
            httpRequest.setURI(this.uri);
        }
        catch (URISyntaxException e) {
            throw HttpClientException.create("check your request uri error by URIBuilder !", e);
        }
        if (null != this.headers) {
            for (NameValuePair header : this.headers) {
                httpRequest.addHeader(header.getName(), header.getValue());
            }
        }
        if (this.hasBody()) {
            this.requestEntity = this.entityBuilder.build();
            httpRequest.setEntity(this.requestEntity);
        }
        return httpRequest;
    }

    private boolean hasBody() {
        return this.hasForm || this.hasOtherBody;
    }

    private CloseableHttpClient getHttpClient() {
        if (null != this.customHttpClient) {
            return this.customHttpClient;
        }
        return DEFAULT_HTTPCLIENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute() {
        try {
            HttpRequestBase request = this.build();
            if (null != this.requestConfig) {
                request.setConfig(this.requestConfig);
            }
            if (logger.isInfoEnabled()) {
                logger.info(RequestConverter.getHttpRequestLog(request, this.requestEntity));
            }
            this.registerDefaultMonitors();
            this.executorMonitorManager.startMonitors();
            CloseableHttpResponse httpResponse = null;
            try {
                httpResponse = this.getHttpClient().execute((HttpUriRequest)request);
                if (null == httpResponse) {
                    throw HttpClientException.create("http builder execute failed as response object is null after execute");
                }
            }
            finally {
                this.executorMonitorManager.endMonitors();
            }
            this.response = Response.from(httpResponse, this.executorMonitorManager);
            if (logger.isInfoEnabled()) {
                logger.info(this.getResponseLog());
            }
            return this.response;
        }
        catch (Exception e) {
            throw HttpClientException.create("send your request error !", e);
        }
    }

    public <T> T execute(HttpBuilderResponseHandler<? extends T> responseHandler) {
        this.execute();
        if (null == this.response) {
            throw HttpClientException.create("response is parse is error as null before call HttpBuilderResponseHandler");
        }
        return responseHandler.handlerResponse(this.response);
    }

    public ExecutorMonitorManager getExecutorMonitorManager() {
        return this.executorMonitorManager;
    }

    private void registerDefaultMonitors() {
        this.executorMonitorManager.register(TimeLineMonitor.create());
    }

    private void add(List<NameValuePair> list, String name, String value) {
        list.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    private void set(List<NameValuePair> list, String name, String value) {
        boolean isFind = false;
        for (int index = 0; index < list.size(); ++index) {
            NameValuePair header = list.get(index);
            if (!header.getName().equals(name)) continue;
            list.set(index, (NameValuePair)new BasicNameValuePair(name, value));
            isFind = true;
            break;
        }
        if (!isFind) {
            list.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    private void remove(List<NameValuePair> list, String name) {
        if (null == list) {
            return;
        }
        for (int index = 0; index < list.size(); ++index) {
            NameValuePair header = list.get(index);
            if (!header.getName().equals(name)) continue;
            list.remove(index);
            break;
        }
    }

    private String getResponseLog() {
        if (null == this.response) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n=======================================[T-" + Thread.currentThread().getId() + " Response ]============================================\n");
            sb.append("Status Line -->[").append(this.response.getStatusLine() + "]\n");
            sb.append("Time Line -->" + this.response.getTimeLine().toString());
            sb.append("\n------------------------ response headers --------------------------\n");
            Header[] responseHeaders = this.response.getAllHeaders();
            if (null != responseHeaders) {
                for (Header header : responseHeaders) {
                    sb.append(header.getName()).append(":").append(header.getValue()).append("\n");
                }
            }
            sb.append("\n------------------------ response content --------------------------\n");
            String content = this.response.getContent();
            if (null != content) {
                sb.append(content);
            }
            sb.append("\n=================================================================================================\n");
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public HttpBuilder setRequestConfig(RequestConfig config) {
        this.requestConfig = config;
        return this;
    }

    public static final class Response {
        private ExecutorMonitorManager executorMonitorManager;
        private CloseableHttpResponse httpResponse;
        private String content;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response(CloseableHttpResponse httpResponse, ExecutorMonitorManager executorMonitorManager) {
            this.httpResponse = httpResponse;
            this.executorMonitorManager = executorMonitorManager;
            if (null != this.httpResponse) {
                try {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    this.content = null == httpEntity ? "" : EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                }
                catch (Exception e) {
                    logger.error("get http builder executed http response content error !", (Throwable)e);
                    this.content = "";
                }
                finally {
                    try {
                        this.httpResponse.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }

        public static Response from(CloseableHttpResponse httpResponse, ExecutorMonitorManager executorMonitorManager) {
            return new Response(httpResponse, executorMonitorManager);
        }

        public TimeLine getTimeLine() {
            TimeLineMonitor tlm = (TimeLineMonitor)this.executorMonitorManager.getMonitor("monitor.TimeRecorder");
            return tlm.toTimeLine();
        }

        public String getContent() {
            return this.content;
        }

        public ProtocolVersion getProtocolVersion() {
            return this.httpResponse.getProtocolVersion();
        }

        public boolean containsHeader(String name) {
            return this.httpResponse.containsHeader(name);
        }

        public Header[] getHeaders(String name) {
            return this.httpResponse.getHeaders(name);
        }

        public Header getFirstHeader(String name) {
            return this.httpResponse.getFirstHeader(name);
        }

        public Header getLastHeader(String name) {
            return this.httpResponse.getLastHeader(name);
        }

        public Header[] getAllHeaders() {
            return this.httpResponse.getAllHeaders();
        }

        public HeaderIterator headerIterator() {
            return this.httpResponse.headerIterator();
        }

        public HeaderIterator headerIterator(String name) {
            return this.httpResponse.headerIterator(name);
        }

        public StatusLine getStatusLine() {
            return this.httpResponse.getStatusLine();
        }
    }

    public static class HttpBuilderXmlResponseHanlder
    implements HttpBuilderResponseHandler<Document> {
        public static HttpBuilderXmlResponseHanlder create() {
            return new HttpBuilderXmlResponseHanlder();
        }

        @Override
        public Document handlerResponse(Response response) {
            return XmlUtils.buildXMLFromStringContent((String)response.getContent());
        }
    }

    public static interface HttpBuilderResponseHandler<T> {
        public T handlerResponse(Response var1);
    }
}

