/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.httpbuilder;

import com.googlecode.openbox.http.httpbuilder.HttpBuilder;
import com.googlecode.openbox.http.monitors.CyclicBarrierMonitor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MultiThreadDemo {
    public static void main(String ... args) {
        int nThreads = 200;
        CyclicBarrierMonitor cyclicBarrier = CyclicBarrierMonitor.create(nThreads);
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        for (int loop = 0; loop < 1000; ++loop) {
            for (int i = 0; i < nThreads; ++i) {
                es.execute(new Task(cyclicBarrier, i));
            }
        }
        es.shutdown();
        try {
            es.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class Task
    implements Runnable {
        private CyclicBarrierMonitor cyclicBarrier;
        private int i;

        public Task(CyclicBarrierMonitor cyclicBarrier, int i) {
            this.cyclicBarrier = cyclicBarrier;
            this.i = i;
        }

        @Override
        public void run() {
            HttpBuilder httpBuilder = HttpBuilder.create().setMethod("GET").setScheme("http").setHost("1.1.1.1").setPort(8999).addParameter("number", "" + this.i);
            httpBuilder.getExecutorMonitorManager().register(this.cyclicBarrier);
            httpBuilder.execute();
        }
    }
}

