/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.monitors;

import com.googlecode.openbox.http.ExecutorMonitor;
import java.util.concurrent.CountDownLatch;

public class CountDownLatchMonitor
implements ExecutorMonitor {
    public static final String NAME = "monitor.CountDownLatchMonitor";
    private CountDownLatch startCountDownLatch;
    private CountDownLatch endCountDownLatch;

    private CountDownLatchMonitor(CountDownLatch startCountDownLatch, CountDownLatch endCountDownLatch) {
        this.startCountDownLatch = startCountDownLatch;
        this.endCountDownLatch = endCountDownLatch;
    }

    public static CountDownLatchMonitor create(CountDownLatch beforeCountDownLatch, CountDownLatch afterCountDownLatch) {
        return new CountDownLatchMonitor(beforeCountDownLatch, afterCountDownLatch);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void start() {
        this.waitCountDownLatch(this.startCountDownLatch);
    }

    @Override
    public void end() {
        this.waitCountDownLatch(this.endCountDownLatch);
    }

    private void waitCountDownLatch(CountDownLatch countDownLatch) {
        if (null != countDownLatch) {
            countDownLatch.countDown();
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

