/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.page;

import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.page.DefaultLinkClicker;
import com.googlecode.openbox.http.page.LinkClicker;
import com.googlecode.openbox.http.page.LinkClickerParser;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public abstract class AbstractLinkClickerParser
implements LinkClickerParser {
    public abstract String parserLink(String var1, Document var2);

    @Override
    public LinkClicker parserNext(LinkClicker parent) {
        parent.checkIfClicked();
        try {
            String content = parent.getResponseContent();
            Document html = Jsoup.parse((String)content);
            String host = this.getHost(parent.getLink());
            String nextLink = this.parserLink(host, html);
            return DefaultLinkClicker.newInstance(parent, nextLink);
        }
        catch (Exception e) {
            throw HttpClientException.create("Parser next link jump error !!!", e);
        }
    }

    private String getHost(String url) {
        return url.substring(0, url.indexOf(47, url.indexOf("//") + 2));
    }
}

