/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.requests;

import com.googlecode.openbox.http.HttpClientException;
import com.googlecode.openbox.http.Request;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

public abstract class FormBodyRequest
extends Request {
    private List<NameValuePair> forms = null;

    public FormBodyRequest(String url) {
        super(url);
    }

    public FormBodyRequest(String scheme, String host, int port, String path) {
        super(scheme, host, port, path);
    }

    public void addForm(String name, String value) {
        if (null == this.forms) {
            this.forms = new LinkedList<NameValuePair>();
        }
        this.add(this.forms, name, value);
    }

    public void setForm(String name, String value) {
        if (null == this.forms) {
            this.forms = new LinkedList<NameValuePair>();
        }
        this.set(this.forms, name, value);
    }

    public void removeForm(String name) {
        this.remove(this.forms, name);
    }

    @Override
    public HttpEntity getEntity() {
        if (null != this.forms && this.forms.size() > 0) {
            try {
                return new UrlEncodedFormEntity(this.forms, CHARSET_UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpClientException("UnsupportedEncodingException as charset =" + CHARSET_UTF_8, e);
            }
        }
        return null;
    }
}

